/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.views.issues;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.Nullable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.sonarlint.eclipse.ui.internal.views.issues.MarkerViewWithBottomPanel;

public class SonarLintReportView
extends MarkerViewWithBottomPanel {
    public static final String ID = "org.sonarlint.eclipse.ui.views.issues.ChangeSetIssuesView";
    private static LocalDateTime reportDate;
    private static String reportTitle;
    private static SonarLintReportView instance;
    private Label label;
    private Composite bottom;

    public SonarLintReportView() {
        super("org.sonarlint.eclipse.ui.views.issues.reportIssueMarkerGenerator");
        instance = this;
    }

    public void dispose() {
        super.dispose();
        instance = null;
    }

    @Override
    protected void populateBottomPanel(Composite bottom) {
        this.bottom = bottom;
        RowLayout bottomLayout = new RowLayout();
        bottomLayout.center = true;
        bottom.setLayout((Layout)bottomLayout);
        GridData bottomLayoutData = new GridData(4, 4, true, false);
        bottom.setLayoutData((Object)bottomLayoutData);
        this.label = new Label(bottom, 0);
        this.refreshText();
    }

    private void refreshText() {
        if (reportTitle != null) {
            this.label.setText(String.valueOf(reportTitle) + " (at " + DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm").format(reportDate) + ")");
        } else {
            this.label.setText("Run the analysis from the SonarLint context menu to find issues in the SCM change set or in all your project files");
        }
    }

    public static void setReportTitle(@Nullable String title) {
        reportDate = title != null ? LocalDateTime.now() : null;
        reportTitle = title;
        if (instance != null) {
            instance.refreshText();
            instance.requestLayout();
        }
    }

    private void requestLayout() {
        this.bottom.getShell().layout(new Control[]{SonarLintReportView.instance.bottom}, 4);
    }
}

