/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.views.issues;

import java.util.Locale;
import javax.annotation.CheckForNull;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;
import org.sonarlint.eclipse.core.internal.utils.CompatibilityUtils;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;

public class IssueDescriptionField
extends MarkerField {
    public int getDefaultColumnWidth(Control control) {
        return 100 * IssueDescriptionField.getFontWidth(control);
    }

    public static final int getFontWidth(Control control) {
        GC gc = new GC((Drawable)control.getDisplay());
        int width = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        return width;
    }

    public String getValue(MarkerItem item) {
        return item.getAttributeValue("message", "Unknow");
    }

    public int compare(MarkerItem item1, MarkerItem item2) {
        int severity2;
        int severity1 = IssueDescriptionField.getSeverity(item1);
        if (severity1 == (severity2 = IssueDescriptionField.getSeverity(item2))) {
            return super.compare(item1, item2);
        }
        return severity2 - severity1;
    }

    private static int getSeverity(MarkerItem item) {
        return IssueDescriptionField.convertSeverity(item.getAttributeValue("sonarseverity", ""));
    }

    public static int convertSeverity(String severity) {
        String severityLower;
        String string = severityLower = severity != null ? severity.toLowerCase(Locale.ENGLISH) : "";
        int result = severityLower.startsWith("blocker") ? 0 : (severityLower.startsWith("critical") ? 1 : (severityLower.startsWith("major") ? 2 : (severityLower.startsWith("minor") ? 3 : (severityLower.startsWith("info") ? 4 : -1))));
        return result;
    }

    @CheckForNull
    private static Image getImage(MarkerItem item) {
        if (item.getMarker() != null) {
            if (CompatibilityUtils.supportRectangleImagesInTreeViewer()) {
                return SonarLintImages.getIssueImage(item.getAttributeValue("sonarseverity", "major"), item.getAttributeValue("issuetype", "code_smell"));
            }
            return SonarLintImages.getSeverityImage(item.getAttributeValue("sonarseverity", "major"));
        }
        String severity = item.getAttributeValue("message", "");
        if (severity.indexOf(32) >= 0) {
            severity = severity.substring(0, severity.indexOf(32));
        }
        if (CompatibilityUtils.supportRectangleImagesInTreeViewer()) {
            return SonarLintImages.getIssueImage(severity, null);
        }
        return SonarLintImages.getSeverityImage(severity);
    }

    public void update(ViewerCell cell) {
        super.update(cell);
        MarkerItem item = (MarkerItem)cell.getElement();
        if (item != null) {
            cell.setImage(IssueDescriptionField.getImage(item));
        }
    }
}

