/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.sonarlint.eclipse.ui.internal.views.AbstractSonarWebView;

public abstract class AbstractLinkedSonarWebView<G>
extends AbstractSonarWebView
implements ISelectionListener {
    protected G currentElement;
    private boolean linking = true;
    private G lastSelection;
    private final IPartListener2 partListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference ref) {
            IWorkbenchPart activePart;
            if (ref.getId().equals(AbstractLinkedSonarWebView.this.getSite().getId()) && (activePart = ref.getPage().getActivePart()) != null) {
                AbstractLinkedSonarWebView.this.selectionChanged(activePart, ref.getPage().getSelection());
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
            if (!ref.getId().equals(AbstractLinkedSonarWebView.this.getSite().getId())) {
                AbstractLinkedSonarWebView.this.computeAndSetInput(ref.getPart(false));
            }
        }

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }
    };

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.createToolbar();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
        this.startListeningForSelectionChanges();
    }

    private void createToolbar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)new LinkAction());
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.update(false);
    }

    protected void setLinkingEnabled(boolean enabled) {
        this.linking = enabled;
        if (this.linking && this.lastSelection != null) {
            this.setInput(this.lastSelection);
        }
    }

    protected boolean isLinkingEnabled() {
        return this.linking;
    }

    protected void startListeningForSelectionChanges() {
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
    }

    protected void stopListeningForSelectionChanges() {
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(part)) {
            return;
        }
        if (!this.linking) {
            G element = this.findSelectedElement(part, selection);
            if (element != null) {
                this.lastSelection = element;
            }
        } else {
            this.lastSelection = null;
            this.computeAndSetInput(part);
        }
    }

    private void computeAndSetInput(IWorkbenchPart part) {
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider == null) {
            return;
        }
        ISelection selection = provider.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        G element = this.findSelectedElement(part, selection);
        if (this.isIgnoringNewInput(element)) {
            return;
        }
        if (element == null) {
            return;
        }
        this.setInput(element);
    }

    public void setInput(G element) {
        this.currentElement = element;
        this.open(element);
    }

    protected abstract void open(G var1);

    protected abstract G findSelectedElement(IWorkbenchPart var1, ISelection var2);

    protected boolean isIgnoringNewInput(G element) {
        return this.currentElement != null && this.currentElement.equals(element) && element != null;
    }

    public void dispose() {
        this.stopListeningForSelectionChanges();
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        super.dispose();
    }

    private class LinkAction
    extends Action {
        private static final String LINK_WITH_SELECTION = "Link with Selection";

        public LinkAction() {
            super(LINK_WITH_SELECTION, 2);
            AbstractLinkedSonarWebView.this.setTitleToolTip(LINK_WITH_SELECTION);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_SYNCED"));
            this.setChecked(AbstractLinkedSonarWebView.this.isLinkingEnabled());
        }

        public void run() {
            AbstractLinkedSonarWebView.this.setLinkingEnabled(!AbstractLinkedSonarWebView.this.isLinkingEnabled());
        }
    }
}

