/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server.wizard;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;
import org.sonarlint.eclipse.ui.internal.server.wizard.AbstractGridLayoutWizardPage;
import org.sonarlint.eclipse.ui.internal.server.wizard.MandatoryValidator;
import org.sonarlint.eclipse.ui.internal.server.wizard.ServerConnectionModel;

public class TokenWizardPage
extends AbstractGridLayoutWizardPage {
    private Text serverTokenText;
    private Binding tokenTextBinding;

    public TokenWizardPage(ServerConnectionModel model) {
        super("server_token_page", "SonarQube Server Authentication Token", model, 3);
    }

    @Override
    protected void doCreateControl(Composite container) {
        this.createTokenField(container);
        this.createOpenSecurityPageButton(container);
        DataBindingContext dbc = new DataBindingContext();
        this.tokenTextBinding = dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.serverTokenText), BeanProperties.value(ServerConnectionModel.class, (String)"username").observe((Object)this.model), new UpdateValueStrategy().setBeforeSetValidator((IValidator)new MandatoryValidator("You must provide an authentication token")), null);
        ControlDecorationSupport.create((ValidationStatusProvider)this.tokenTextBinding, (int)16512);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
    }

    private void createTokenField(Composite container) {
        Label labelUsername = new Label(container, 0);
        labelUsername.setText("Token:");
        this.serverTokenText = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 10;
        this.serverTokenText.setLayoutData((Object)gd);
    }

    private void createOpenSecurityPageButton(Composite container) {
        Button button = new Button(container, 8);
        button.setImage(SonarLintImages.IMG_OPEN_EXTERNAL);
        button.setText(Messages.ServerLocationWizardPage_action_token);
        button.setToolTipText(Messages.ServerLocationWizardPage_action_token_tooltip);
        button.setLayoutData((Object)new GridData(256));
        button.addListener(13, e -> this.openSecurityPage());
    }

    private void openSecurityPage() {
        StringBuilder url = new StringBuilder(256);
        url.append(this.model.getServerUrl());
        url.append("/account/security");
        try {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(url.toString()));
        }
        catch (MalformedURLException | PartInitException e) {
            SonarLintLogger.get().error("Unable to open external browser", e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Unable to open external browser: " + e.getMessage()));
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.tokenTextBinding.validateTargetToModel();
        }
    }
}

