/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server.wizard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.sonarlint.eclipse.ui.internal.server.wizard.ServerConnectionModel;
import org.sonarsource.sonarlint.core.client.api.connected.RemoteOrganization;
import org.sonarsource.sonarlint.core.client.api.util.TextSearchIndex;

public class OrganizationProvider
implements IContentProposalProvider {
    private final ServerConnectionModel model;
    private final WizardPage parentPage;

    public OrganizationProvider(ServerConnectionModel model, WizardPage parentPage) {
        this.model = model;
        this.parentPage = parentPage;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        Map filtered;
        ArrayList<ContentProposal> list = new ArrayList<ContentProposal>();
        TextSearchIndex<RemoteOrganization> organizationsIndex = this.model.getOrganizationsIndex();
        Map map = filtered = organizationsIndex != null ? organizationsIndex.search(contents) : Collections.emptyMap();
        if (filtered.isEmpty()) {
            this.parentPage.setMessage("No results", 1);
        } else {
            this.parentPage.setMessage("", 0);
        }
        ArrayList entries = new ArrayList(filtered.entrySet());
        entries.sort(Comparator.comparing(Map.Entry::getValue).reversed().thenComparing(Comparator.comparing(e -> ((RemoteOrganization)e.getKey()).getName(), String.CASE_INSENSITIVE_ORDER)));
        for (Map.Entry entry : entries) {
            list.add(new ContentProposal(((RemoteOrganization)entry.getKey()).getKey(), ((RemoteOrganization)entry.getKey()).getName(), OrganizationProvider.toDescription((RemoteOrganization)entry.getKey())));
        }
        return list.toArray(new IContentProposal[list.size()]);
    }

    private static String toDescription(RemoteOrganization org) {
        StringBuilder sb = new StringBuilder();
        sb.append("Name: ").append(org.getName()).append("\n");
        sb.append("Key: ").append(org.getKey()).append("\n");
        sb.append("Description: ").append(org.getDescription());
        return sb.toString();
    }
}

