/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.TriggerType;
import org.sonarlint.eclipse.core.internal.adapter.Adapters;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectJob;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectRequest;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProjectConfiguration;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.SonarLintProjectDecorator;

public class JobUtils {
    private JobUtils() {
    }

    public static void scheduleAnalysisOfOpenFiles(@Nullable ISonarLintProject project, TriggerType triggerType) {
        HashMap<ISonarLintProject, List<AnalyzeProjectRequest.FileWithDocument>> filesByProject = new HashMap<ISonarLintProject, List<AnalyzeProjectRequest.FileWithDocument>>();
        JobUtils.collectOpenedFiles(project, filesByProject);
        for (Map.Entry entry : filesByProject.entrySet()) {
            ISonarLintProject aProject = (ISonarLintProject)entry.getKey();
            if (!aProject.isOpen() || !SonarLintProjectConfiguration.read((IScopeContext)aProject.getScopeContext()).isAutoEnabled()) continue;
            AnalyzeProjectRequest request = new AnalyzeProjectRequest(aProject, (Collection)entry.getValue(), triggerType);
            new AnalyzeProjectJob(request).schedule();
        }
    }

    private static void collectOpenedFiles(ISonarLintProject project, Map<ISonarLintProject, List<AnalyzeProjectRequest.FileWithDocument>> filesByProject) {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow win = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = win.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference ref = iEditorReferenceArray[n6];
                    JobUtils.collectOpenedFile(project, filesByProject, ref);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void collectOpenedFile(@Nullable ISonarLintProject project, Map<ISonarLintProject, List<AnalyzeProjectRequest.FileWithDocument>> filesByProject, IEditorReference ref) {
        IFile file;
        ISonarLintFile sonarFile;
        IEditorPart editor = ref.getEditor(false);
        if (editor == null) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput && (sonarFile = (ISonarLintFile)Adapters.adapt((Object)(file = ((IFileEditorInput)input).getFile()), ISonarLintFile.class)) != null && (project == null || sonarFile.getProject().equals(project))) {
            filesByProject.putIfAbsent(sonarFile.getProject(), new ArrayList());
            if (editor instanceof ITextEditor) {
                IDocument doc = ((ITextEditor)editor).getDocumentProvider().getDocument((Object)input);
                filesByProject.get(sonarFile.getProject()).add(new AnalyzeProjectRequest.FileWithDocument(sonarFile, doc));
            } else {
                filesByProject.get(sonarFile.getProject()).add(new AnalyzeProjectRequest.FileWithDocument(sonarFile, null));
            }
        }
    }

    public static void scheduleAnalysisOfOpenFiles(List<ISonarLintProject> projects, TriggerType triggerType) {
        projects.forEach(p -> JobUtils.scheduleAnalysisOfOpenFiles(p, triggerType));
    }

    public static void scheduleAnalysisOfOpenFilesInBoundProjects(IServer server, TriggerType triggerType) {
        JobUtils.scheduleAnalysisOfOpenFiles(server.getBoundProjects(), triggerType);
    }

    public static void scheduleAnalysisOfOpenFiles(Job job, List<ISonarLintProject> projects, TriggerType triggerType) {
        JobUtils.scheduleAfterSuccess(job, () -> JobUtils.scheduleAnalysisOfOpenFiles(projects, triggerType));
    }

    public static void scheduleAfter(Job job, final Runnable runnable) {
        job.addJobChangeListener((IJobChangeListener)new JobCompletionListener(){

            public void done(IJobChangeEvent event) {
                runnable.run();
            }
        });
    }

    public static void scheduleAfterSuccess(Job job, final Runnable runnable) {
        job.addJobChangeListener((IJobChangeListener)new JobCompletionListener(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    runnable.run();
                }
            }
        });
    }

    public static void scheduleAnalysisOfOpenFilesInBoundProjects(Job job, IServer server, TriggerType triggerType) {
        JobUtils.scheduleAnalysisOfOpenFiles(job, server.getBoundProjects(), triggerType);
    }

    public static void notifyServerViewAfterBindingChange(ISonarLintProject sonarProject, @Nullable String oldServerId) {
        IBaseLabelProvider labelProvider;
        IServer server;
        IServer oldServer;
        SonarLintProjectConfiguration projectConfig = SonarLintProjectConfiguration.read((IScopeContext)sonarProject.getScopeContext());
        String serverId = projectConfig.getServerId();
        if (oldServerId != null && !Objects.equals(serverId, oldServerId) && (oldServer = SonarLintCorePlugin.getServersManager().getServer(oldServerId)) != null) {
            oldServer.notifyAllListeners();
        }
        if (serverId != null && (server = SonarLintCorePlugin.getServersManager().getServer(serverId)) != null) {
            server.notifyAllListeners();
        }
        if ((labelProvider = PlatformUI.getWorkbench().getDecoratorManager().getBaseLabelProvider("org.sonarlint.eclipse.ui.sonarlintDecorator")) != null) {
            ((SonarLintProjectDecorator)labelProvider).fireChange(Arrays.asList(sonarProject));
        }
    }

    static abstract class JobCompletionListener
    implements IJobChangeListener {
        JobCompletionListener() {
        }

        public void aboutToRun(IJobChangeEvent event) {
        }

        public void awake(IJobChangeEvent event) {
        }

        public void running(IJobChangeEvent event) {
        }

        public void scheduled(IJobChangeEvent event) {
        }

        public void sleeping(IJobChangeEvent event) {
        }
    }
}

