/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.CommonViewerSiteFactory;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.navigator.NavigatorActionService;
import org.eclipse.ui.part.PageBook;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.server.IServerLifecycleListener;
import org.sonarlint.eclipse.core.internal.server.IServerListener;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.server.wizard.ServerConnectionWizard;

public class ServersView
extends CommonNavigator {
    public static final String ID = "org.sonarlint.eclipse.ui.ServersView";
    private static final String SERVERS_VIEW_CONTEXT = "org.eclipse.ui.sonarlintServerViewScope";
    protected CommonViewer tableViewer;
    private Control mainPage;
    private Control noServersPage;
    private PageBook book;
    private IServerLifecycleListener serverResourceListener;
    private IServerListener serverListener;

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.book = new PageBook(parent, 0);
        super.createPartControl((Composite)this.book);
        this.mainPage = this.getCommonViewer().getControl();
        this.noServersPage = this.createDefaultPage(toolkit);
        this.book.showPage(this.mainPage);
        IContextService contextSupport = (IContextService)this.getSite().getService(IContextService.class);
        contextSupport.activateContext(SERVERS_VIEW_CONTEXT);
        this.deferInitialization();
    }

    private Control createDefaultPage(FormToolkit kit) {
        ICommonViewerWorkbenchSite commonViewerSite;
        Form form = kit.createForm((Composite)this.book);
        Composite body = form.getBody();
        GridLayout layout = new GridLayout(2, false);
        body.setLayout((Layout)layout);
        Link hlink = new Link(body, 0);
        hlink.setText(Messages.ServersView_noServers);
        hlink.setBackground(this.book.getDisplay().getSystemColor(25));
        GridData gd = new GridData(16384, 4, true, false);
        hlink.setLayoutData((Object)gd);
        hlink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardDialog wd = ServerConnectionWizard.createDialog(ServersView.this.book.getShell());
                if (wd.open() == 0) {
                    ServersView.this.toggleDefaultPage();
                }
            }
        });
        CommonViewer commonViewer = this.getCommonViewer();
        if (commonViewer != null && (commonViewerSite = CommonViewerSiteFactory.createCommonViewerSite((IViewSite)this.getViewSite())) != null) {
            NavigatorActionService actionService = new NavigatorActionService((ICommonViewerSite)commonViewerSite, (StructuredViewer)commonViewer, commonViewer.getNavigatorContentService());
            MenuManager menuManager = new MenuManager("#PopupMenu");
            menuManager.addMenuListener(mgr -> {
                ISelection selection = commonViewer.getSelection();
                actionService.setContext(new ActionContext(selection));
                actionService.fillContextMenu(mgr);
            });
            Menu menu = menuManager.createContextMenu((Control)body);
            body.setMenu(menu);
            hlink.setMenu(menu);
        }
        return form;
    }

    void toggleDefaultPage() {
        if (this.tableViewer.getTree().getItemCount() < 1) {
            this.book.showPage(this.noServersPage);
        } else {
            this.book.showPage(this.mainPage);
        }
    }

    private void deferInitialization() {
        Job job = new Job(Messages.jobInitializingServersView){

            public IStatus run(IProgressMonitor monitor) {
                ServersView.this.deferredInitialize();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(20);
        job.schedule();
    }

    protected void deferredInitialize() {
        this.addListener();
        Display.getDefault().asyncExec(() -> {
            try {
                this.tableViewer = this.getCommonViewer();
                this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
                try {
                    if (this.tableViewer.getTree().getItemCount() > 0) {
                        Object obj = this.tableViewer.getTree().getItem(0).getData();
                        this.tableViewer.setSelection((ISelection)new StructuredSelection(obj));
                    } else {
                        this.toggleDefaultPage();
                    }
                }
                catch (Exception e1) {
                    throw new IllegalStateException("Unable to update servers", e1);
                }
            }
            catch (Exception exception) {}
        });
    }

    protected void refreshServerContent(IServer server) {
        Display.getDefault().asyncExec(() -> {
            if (!this.tableViewer.getTree().isDisposed()) {
                this.tableViewer.refresh((Object)server, true);
            }
        });
    }

    protected void refreshServerState() {
        Display.getDefault().asyncExec(() -> {
            IDecoratorManager dm = PlatformUI.getWorkbench().getDecoratorManager();
            dm.update("org.sonarlint.eclipse.ui.navigatorDecorator");
            if (this.tableViewer != null) {
                this.tableViewer.setSelection(this.tableViewer.getSelection());
            }
        });
    }

    protected void addListener() {
        this.serverResourceListener = new IServerLifecycleListener(){

            public void serverAdded(IServer server) {
                ServersView.this.addServer(server);
                server.addServerListener(ServersView.this.serverListener);
            }

            public void serverChanged(IServer server) {
                ServersView.this.refreshServerContent(server);
            }

            public void serverRemoved(IServer server) {
                ServersView.this.removeServer(server);
                server.removeServerListener(ServersView.this.serverListener);
            }
        };
        SonarLintCorePlugin.getServersManager().addServerLifecycleListener(this.serverResourceListener);
        this.serverListener = server -> {
            this.refreshServerState();
            this.refreshServerContent((IServer)server);
        };
        for (IServer server2 : SonarLintCorePlugin.getServersManager().getServers()) {
            server2.addServerListener(this.serverListener);
        }
    }

    protected void addServer(IServer server) {
        Display.getDefault().asyncExec(() -> {
            this.tableViewer.add(this.tableViewer.getInput(), (Object)server);
            this.toggleDefaultPage();
        });
    }

    protected void removeServer(IServer server) {
        Display.getDefault().asyncExec(() -> {
            this.tableViewer.remove(this.tableViewer.getInput(), new Object[]{server});
            this.toggleDefaultPage();
        });
    }

    public void dispose() {
        SonarLintCorePlugin.getServersManager().removeServerLifecycleListener(this.serverResourceListener);
        super.dispose();
    }
}

