/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.bind.BindProjectsWizard;
import org.sonarlint.eclipse.ui.internal.server.actions.NewServerWizardAction;
import org.sonarlint.eclipse.ui.internal.server.actions.ProjectChangeBindingAction;
import org.sonarlint.eclipse.ui.internal.server.actions.ServerEditAction;
import org.sonarlint.eclipse.ui.internal.server.actions.ServerOrProjectDeleteAction;
import org.sonarlint.eclipse.ui.internal.server.actions.ServerUpdateAction;

public class ServerActionProvider
extends CommonActionProvider {
    public static final String NEW_MENU_ID = "org.sonarlint.eclipse.ui.server.newMenuId";
    private ICommonActionExtensionSite actionSite;
    protected Action deleteAction;
    protected Action editAction;
    protected Action updateAction;
    protected Action updateBindingAction;

    public void init(ICommonActionExtensionSite aSite) {
        StructuredViewer v;
        super.init(aSite);
        this.actionSite = aSite;
        ICommonViewerSite site = aSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite && (v = aSite.getStructuredViewer()) instanceof CommonViewer) {
            CommonViewer cv = (CommonViewer)v;
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            ServerActionProvider.addListeners(cv);
            this.makeServerActions(cv, wsSite.getSelectionProvider());
        }
    }

    private static void addListeners(CommonViewer tableViewer) {
        tableViewer.addOpenListener(event -> {
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            Object data = sel.getFirstElement();
            if (data instanceof IServer) {
                IServer server = (IServer)data;
                ServerEditAction.openEditWizard(tableViewer.getTree().getShell(), server);
            } else if (data instanceof ISonarLintProject) {
                BindProjectsWizard wizard = new BindProjectsWizard(Arrays.asList((ISonarLintProject)data));
                WizardDialog dialog = new WizardDialog(tableViewer.getTree().getShell(), (IWizard)wizard);
                dialog.setHelpAvailable(true);
                dialog.open();
            }
        });
    }

    private void makeServerActions(CommonViewer tableViewer, ISelectionProvider provider) {
        Shell shell = tableViewer.getTree().getShell();
        this.deleteAction = new ServerOrProjectDeleteAction(shell, provider);
        this.editAction = new ServerEditAction(shell, provider);
        this.updateAction = new ServerUpdateAction(provider);
        this.updateBindingAction = new ProjectChangeBindingAction(shell, provider);
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.updateActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.editAction);
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.updateAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.removeAll();
        ICommonViewerSite site = this.actionSite.getViewSite();
        IStructuredSelection selection = null;
        if (site instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            selection = (IStructuredSelection)wsSite.getSelectionProvider().getSelection();
        }
        ArrayList<IServer> servers = new ArrayList<IServer>();
        ArrayList<ISonarLintProject> projects = new ArrayList<ISonarLintProject>();
        ServerActionProvider.populateServersAndProjects(selection, servers, projects);
        if (projects.isEmpty()) {
            this.addTopSection(menu);
            menu.add((IContributionItem)new Separator());
        }
        if (servers.size() == 1 && projects.isEmpty()) {
            menu.add((IAction)this.editAction);
        }
        if (!servers.isEmpty() && projects.isEmpty()) {
            menu.add((IAction)this.updateAction);
        }
        if (servers.isEmpty() && !projects.isEmpty()) {
            menu.add((IAction)this.updateBindingAction);
        }
        if (servers.isEmpty() != projects.isEmpty()) {
            menu.add((IAction)this.deleteAction);
        }
    }

    private static void populateServersAndProjects(IStructuredSelection selection, List<IServer> servers, List<ISonarLintProject> projects) {
        if (selection != null && !selection.isEmpty()) {
            for (Object obj : selection) {
                if (obj instanceof IServer) {
                    servers.add((IServer)obj);
                    continue;
                }
                if (!(obj instanceof ISonarLintProject)) continue;
                projects.add((ISonarLintProject)obj);
            }
        }
    }

    protected void addTopSection(IMenuManager menu) {
        MenuManager newMenu = new MenuManager(Messages.actionNew, NEW_MENU_ID);
        NewServerWizardAction newServerAction = new NewServerWizardAction();
        newServerAction.setText(Messages.actionNewServer);
        newMenu.add((IAction)newServerAction);
        menu.add((IContributionItem)newMenu);
    }
}

