/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.properties;

import java.util.Arrays;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.dialogs.PropertyPage;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.adapter.Adapters;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProjectConfiguration;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.bind.BindProjectsWizard;
import org.sonarlint.eclipse.ui.internal.server.wizard.ServerConnectionWizard;

public class SonarLintProjectPropertyPage
extends PropertyPage {
    private Button enabledBtn;
    private Link addServerLink;
    private Link bindLink;
    private Composite container;
    private Label boundDetails;

    public SonarLintProjectPropertyPage() {
        this.setTitle(Messages.SonarProjectPropertyPage_title);
    }

    protected Control createContents(Composite parent) {
        if (parent == null) {
            return new Composite(parent, 0);
        }
        SonarLintProjectConfiguration projectConfig = SonarLintProjectConfiguration.read((IScopeContext)this.getProject().getScopeContext());
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        this.enabledBtn = new Button(this.container, 32);
        this.enabledBtn.setText("Run SonarLint automatically");
        this.enabledBtn.setSelection(projectConfig.isAutoEnabled());
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.enabledBtn.setLayoutData((Object)layoutData);
        this.boundDetails = new Label(this.container, 0);
        this.boundDetails.setLayoutData((Object)new GridData(768));
        this.addServerLink = new Link(this.container, 0);
        GridData gd = new GridData(16384, 4, true, false);
        gd.horizontalSpan = 2;
        this.addServerLink.setLayoutData((Object)gd);
        this.addServerLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String serverId = SonarLintProjectConfiguration.read((IScopeContext)SonarLintProjectPropertyPage.this.getProject().getScopeContext()).getServerId();
                WizardDialog wd = ServerConnectionWizard.createDialog(SonarLintProjectPropertyPage.this.container.getShell(), serverId);
                if (wd.open() == 0) {
                    SonarLintProjectPropertyPage.this.updateState();
                }
            }
        });
        this.bindLink = new Link(this.container, 0);
        gd = new GridData(16384, 4, true, false);
        gd.horizontalSpan = 2;
        this.bindLink.setLayoutData((Object)gd);
        this.bindLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindProjectsWizard wizard = new BindProjectsWizard(Arrays.asList(SonarLintProjectPropertyPage.this.getProject()));
                WizardDialog wd = new WizardDialog(SonarLintProjectPropertyPage.this.container.getShell(), (IWizard)wizard);
                if (wd.open() == 0) {
                    SonarLintProjectPropertyPage.this.updateState();
                }
            }
        });
        this.updateState();
        return this.container;
    }

    private void updateState() {
        SonarLintProjectConfiguration projectConfig = SonarLintProjectConfiguration.read((IScopeContext)this.getProject().getScopeContext());
        String moduleKey = projectConfig.getModuleKey();
        String serverId = projectConfig.getServerId();
        if (moduleKey == null && serverId == null) {
            this.bindLink.setText("<a>Bind this Eclipse project to a SonarQube project</a>");
            this.boundDetails.setText("");
        } else {
            this.boundDetails.setText("Bound to the project '" + moduleKey + "' on server '" + SonarLintProjectPropertyPage.serverName(serverId) + "'");
            this.bindLink.setText("<a>Update project binding</a>");
        }
        if (serverId != null && SonarLintCorePlugin.getServersManager().getServer(serverId) == null) {
            this.addServerLink.setText("<a>Connect to SonarQube server '" + serverId + "'</a>");
            this.addServerLink.setVisible(true);
        } else {
            this.addServerLink.setVisible(false);
        }
        this.container.layout(true, true);
    }

    private static String serverName(String serverId) {
        if (serverId == null) {
            return "";
        }
        IServer server = SonarLintCorePlugin.getServersManager().getServer(serverId);
        return server != null ? server.getId() : "Unknown server: '" + serverId + "'";
    }

    protected void performDefaults() {
        this.enabledBtn.setEnabled(true);
        super.performDefaults();
    }

    public boolean performOk() {
        SonarLintProjectConfiguration projectConfig = SonarLintProjectConfiguration.read((IScopeContext)this.getProject().getScopeContext());
        projectConfig.setAutoEnabled(this.enabledBtn.getSelection());
        projectConfig.save();
        return super.performOk();
    }

    private ISonarLintProject getProject() {
        return (ISonarLintProject)Adapters.adapt((Object)this.getElement(), ISonarLintProject.class);
    }
}

