/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.properties;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.adapter.Adapters;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProjectConfiguration;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProperty;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.SonarLintUiPlugin;
import org.sonarlint.eclipse.ui.internal.properties.EditSonarPropertyDialog;

public class SonarLintExtraArgumentsPreferenceAndPropertyPage
extends PropertyPage
implements IWorkbenchPreferencePage {
    private static final String VALUE = "Value";
    private static final String PREFERENCE_ID = "org.sonarlint.eclipse.ui.properties.SonarExtraArgumentsPreferenceAndPropertyPage";
    private List<SonarLintProperty> sonarProperties;
    private Button removeButton;
    private Button editButton;
    private Button upButton;
    private Button downButton;
    private TableViewer fTableViewer;

    public SonarLintExtraArgumentsPreferenceAndPropertyPage() {
        this.setTitle(Messages.SonarPreferencePage_label_extra_args);
    }

    protected Control createContents(Composite ancestor) {
        this.loadProperties();
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        if (!this.isGlobal()) {
            SonarLintExtraArgumentsPreferenceAndPropertyPage.createLinkToGlobal(ancestor, parent);
        }
        Composite innerParent = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        innerParent.setLayoutData((Object)gd);
        Composite tableComposite = new Composite(innerParent, 0);
        GridData data = new GridData(1808);
        data.widthHint = 360;
        data.heightHint = this.convertHeightInCharsToPixels(10);
        tableComposite.setLayoutData((Object)data);
        TableColumnLayout columnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)columnLayout);
        Table table = new Table(tableComposite, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GC gc = new GC((Drawable)this.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        TableColumn propertyNameColumn = new TableColumn(table, 0);
        propertyNameColumn.setText("Name");
        int minWidth = SonarLintExtraArgumentsPreferenceAndPropertyPage.computeMinimumColumnWidth(gc, "Name");
        columnLayout.setColumnData((Widget)propertyNameColumn, (ColumnLayoutData)new ColumnWeightData(1, minWidth, true));
        TableColumn propertyValueColumn = new TableColumn(table, 0);
        propertyValueColumn.setText(VALUE);
        minWidth = SonarLintExtraArgumentsPreferenceAndPropertyPage.computeMinimumColumnWidth(gc, VALUE);
        columnLayout.setColumnData((Widget)propertyValueColumn, (ColumnLayoutData)new ColumnWeightData(1, minWidth, true));
        gc.dispose();
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new SonarPropertiesLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new SonarPropertiesContentProvider());
        this.fTableViewer.setComparator(null);
        this.fTableViewer.addDoubleClickListener(e -> this.edit());
        this.fTableViewer.addSelectionChangedListener(e -> this.updateButtons());
        this.createButtons(innerParent);
        this.fTableViewer.setInput(this.sonarProperties);
        this.updateButtons();
        Dialog.applyDialogFont((Control)parent);
        innerParent.layout();
        return parent;
    }

    private void createButtons(Composite innerParent) {
        Composite buttons = new Composite(innerParent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        Button addButton = new Button(buttons, 8);
        addButton.setText("New...");
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addListener(13, e -> this.add());
        this.editButton = new Button(buttons, 8);
        this.editButton.setText("Edit...");
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.addListener(13, e -> this.edit());
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText("Remove");
        this.removeButton.setLayoutData((Object)new GridData(768));
        this.removeButton.addListener(13, e -> this.remove());
        this.upButton = new Button(buttons, 8);
        this.upButton.setText("Up");
        this.upButton.setLayoutData((Object)new GridData(768));
        this.upButton.addListener(13, e -> this.upPressed());
        this.downButton = new Button(buttons, 8);
        this.downButton.setText("Down");
        this.downButton.setLayoutData((Object)new GridData(768));
        this.downButton.addListener(13, e -> this.downPressed());
    }

    private static void createLinkToGlobal(final Composite ancestor, Composite parent) {
        Link fLink = new Link(parent, 0);
        fLink.setText("<A>Configure Workspace Settings...</A>");
        fLink.setLayoutData((Object)new GridData());
        SelectionAdapter sl = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)ancestor.getShell(), (String)SonarLintExtraArgumentsPreferenceAndPropertyPage.PREFERENCE_ID, null, null).open();
            }
        };
        fLink.addSelectionListener((SelectionListener)sl);
    }

    private void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] objects = selection.toArray();
        if (objects == null || objects.length != 1) {
            return;
        }
        SonarLintProperty data = (SonarLintProperty)selection.getFirstElement();
        this.edit(data);
    }

    private void add() {
        SonarLintProperty newProperty = this.editSonarProperty(new SonarLintProperty("", ""), false, true);
        if (newProperty != null) {
            this.sonarProperties.add(newProperty);
            this.fTableViewer.refresh();
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)newProperty));
        }
    }

    private void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        for (SonarLintProperty data : selection) {
            this.sonarProperties.remove(data);
        }
        this.fTableViewer.refresh();
    }

    private void edit(SonarLintProperty data) {
        SonarLintProperty oldProp = data;
        SonarLintProperty newProp = this.editSonarProperty(new SonarLintProperty(oldProp), true, false);
        if (newProp != null) {
            data.setValue(newProp.getValue());
            this.fTableViewer.refresh((Object)data);
            this.updateButtons();
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)data));
        }
    }

    protected void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        int selectionCount = selection.size();
        int itemCount = this.fTableViewer.getTable().getItemCount();
        this.editButton.setEnabled(selectionCount == 1);
        this.removeButton.setEnabled(selectionCount > 0 && selectionCount <= itemCount);
        int index = this.sonarProperties.indexOf(selection.getFirstElement());
        this.removeButton.setEnabled(index >= 0);
        this.upButton.setEnabled(itemCount > 1 && index > 0);
        this.downButton.setEnabled(itemCount > 1 && index >= 0 && index < itemCount - 1);
    }

    protected SonarLintProperty editSonarProperty(SonarLintProperty property, boolean edit, boolean isNameModifiable) {
        EditSonarPropertyDialog dialog = new EditSonarPropertyDialog(this.getShell(), property, edit, isNameModifiable);
        if (dialog.open() == 0) {
            return dialog.getSonarProperty();
        }
        return null;
    }

    private static int computeMinimumColumnWidth(GC gc, String string) {
        return gc.stringExtent((String)string).x + 10;
    }

    private void downPressed() {
        this.swap(false);
    }

    private void swap(boolean up) {
        int target;
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] objects = selection.toArray();
        if (objects == null || objects.length != 1) {
            return;
        }
        SonarLintProperty data = (SonarLintProperty)selection.getFirstElement();
        int index = this.sonarProperties.indexOf(data);
        int n = target = up ? index - 1 : index + 1;
        if (index >= 0) {
            this.sonarProperties.remove(index);
            this.sonarProperties.add(target, data);
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)data));
            this.fTableViewer.refresh();
            this.updateButtons();
        }
    }

    private void upPressed() {
        this.swap(true);
    }

    public void init(IWorkbench workbench) {
        this.setDescription("Additional properties passed to SonarLint analyzers");
        this.setPreferenceStore(SonarLintUiPlugin.getDefault().getPreferenceStore());
    }

    private void loadProperties() {
        this.sonarProperties = new ArrayList<SonarLintProperty>();
        if (this.isGlobal()) {
            String props = this.getPreferenceStore().getString("extraArgs");
            try {
                String[] keyValuePairs;
                String[] stringArray = keyValuePairs = StringUtils.split((String)props, (String)"\r\n");
                int n = keyValuePairs.length;
                int n2 = 0;
                while (n2 < n) {
                    String keyValuePair = stringArray[n2];
                    String[] keyValue = StringUtils.split((String)keyValuePair, (String)"=");
                    this.sonarProperties.add(new SonarLintProperty(keyValue[0], keyValue[1]));
                    ++n2;
                }
            }
            catch (Exception e) {
                SonarLintLogger.get().error("Error while loading SonarLint analyzer properties" + props, (Throwable)e);
            }
        } else {
            SonarLintProjectConfiguration sonarProject = this.getProjectConfig();
            if (sonarProject != null) {
                this.sonarProperties.addAll(sonarProject.getExtraProperties());
            }
        }
    }

    public boolean performOk() {
        ArrayList<String> keyValuePairs = new ArrayList<String>(this.sonarProperties.size());
        for (SonarLintProperty prop : this.sonarProperties) {
            keyValuePairs.add(String.valueOf(prop.getName()) + "=" + prop.getValue());
        }
        String props = StringUtils.joinSkipNull(keyValuePairs, (String)"\r\n");
        if (this.isGlobal()) {
            this.getPreferenceStore().setValue("extraArgs", props);
        } else {
            SonarLintProjectConfiguration sonarProject = this.getProjectConfig();
            if (sonarProject != null) {
                sonarProject.setExtraProperties(this.sonarProperties);
                sonarProject.save();
            }
        }
        return true;
    }

    protected void performDefaults() {
        this.sonarProperties.clear();
        this.fTableViewer.refresh();
    }

    private ISonarLintProject getProject() {
        return (ISonarLintProject)Adapters.adapt((Object)this.getElement(), ISonarLintProject.class);
    }

    @CheckForNull
    private SonarLintProjectConfiguration getProjectConfig() {
        ISonarLintProject project = this.getProject();
        if (project != null) {
            return SonarLintProjectConfiguration.read((IScopeContext)project.getScopeContext());
        }
        return null;
    }

    private boolean isGlobal() {
        return this.getElement() == null;
    }

    private static class SonarPropertiesContentProvider
    implements IStructuredContentProvider {
        private List<SonarLintProperty> sonarProperties;

        private SonarPropertiesContentProvider() {
        }

        public Object[] getElements(Object input) {
            return this.sonarProperties.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.sonarProperties = (List)newInput;
        }

        public void dispose() {
            this.sonarProperties = null;
        }
    }

    private static class SonarPropertiesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private SonarPropertiesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            SonarLintProperty data = (SonarLintProperty)element;
            switch (columnIndex) {
                case 0: {
                    return data.getName();
                }
                case 1: {
                    return data.getValue();
                }
            }
            return "";
        }
    }
}

