/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.markers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.markers.MarkerUtils;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;
import org.sonarlint.eclipse.ui.internal.views.locations.IssueLocationsView;

public class ShowIssueFlowsMarkerResolver
implements IMarkerResolution2 {
    private static final String ISSUE_FLOW_ANNOTATION_TYPE = "org.sonarlint.eclipse.issueFlowAnnotationType";
    private final IMarker marker;

    public ShowIssueFlowsMarkerResolver(IMarker marker) {
        this.marker = marker;
    }

    public String getDescription() {
        return "Show/Hide all locations to better understand the issue: " + this.marker.getAttribute("message", "unknown");
    }

    public String getLabel() {
        return "Toggle all issue locations";
    }

    public void run(IMarker marker) {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IMarker)marker);
            if (editorPart instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editorPart;
                ShowIssueFlowsMarkerResolver.toggleAnnotations(marker, textEditor);
            }
        }
        catch (Exception e) {
            SonarLintLogger.get().error("Unable to show issue locations", (Throwable)e);
        }
    }

    private static void updateLocationsView(IMarker marker) {
        try {
            IssueLocationsView view = (IssueLocationsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.sonarlint.eclipse.ui.views.IssueLocationsView");
            view.setShowAnnotations(true);
            view.setInput(marker);
        }
        catch (PartInitException e) {
            SonarLintLogger.get().error("Unable to open Issue Locations View", (Throwable)e);
        }
    }

    private static void toggleAnnotations(IMarker marker, ITextEditor textEditor) {
        boolean annotationAlreadyDisplayedForThisMarker;
        IEditorInput editorInput = textEditor.getEditorInput();
        IAnnotationModel annotationModel = textEditor.getDocumentProvider().getAnnotationModel((Object)editorInput);
        IDocument doc = textEditor.getDocumentProvider().getDocument((Object)editorInput);
        Map<Annotation, Position> newAnnotations = ShowIssueFlowsMarkerResolver.createAnnotations(marker, doc);
        List<Annotation> existingFlowAnnotations = ShowIssueFlowsMarkerResolver.existingFlowAnnotations(annotationModel);
        boolean bl = annotationAlreadyDisplayedForThisMarker = !existingFlowAnnotations.isEmpty() && newAnnotations.containsValue(annotationModel.getPosition(existingFlowAnnotations.iterator().next()));
        if (!annotationAlreadyDisplayedForThisMarker) {
            ShowIssueFlowsMarkerResolver.updateLocationsView(marker);
        } else {
            IssueLocationsView view = (IssueLocationsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.sonarlint.eclipse.ui.views.IssueLocationsView");
            if (view != null) {
                view.setShowAnnotations(false);
            }
            ShowIssueFlowsMarkerResolver.removePreviousAnnotations(annotationModel);
        }
    }

    public static void showAnnotations(IMarker marker, ITextEditor textEditor) {
        IEditorInput editorInput = textEditor.getEditorInput();
        IAnnotationModel annotationModel = textEditor.getDocumentProvider().getAnnotationModel((Object)editorInput);
        IDocument doc = textEditor.getDocumentProvider().getDocument((Object)editorInput);
        Map<Annotation, Position> newAnnotations = ShowIssueFlowsMarkerResolver.createAnnotations(marker, doc);
        List<Annotation> existingFlowAnnotations = ShowIssueFlowsMarkerResolver.existingFlowAnnotations(annotationModel);
        if (annotationModel instanceof IAnnotationModelExtension) {
            ((IAnnotationModelExtension)annotationModel).replaceAnnotations(existingFlowAnnotations.toArray(new Annotation[0]), newAnnotations);
        } else {
            ShowIssueFlowsMarkerResolver.removePreviousAnnotations(annotationModel);
            newAnnotations.forEach((arg_0, arg_1) -> ((IAnnotationModel)annotationModel).addAnnotation(arg_0, arg_1));
        }
    }

    private static Map<Annotation, Position> createAnnotations(IMarker marker, IDocument doc) {
        Position[] positions;
        try {
            positions = doc.getPositions("sonarlintextralocations");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            SonarLintLogger.get().debug("No extra positions found, should maybe trigger a new analysis");
            return Collections.emptyMap();
        }
        return Arrays.asList(positions).stream().map(p -> (MarkerUtils.ExtraPosition)p).filter(p -> p.getMarkerId() == marker.getId() && !p.isDeleted).collect(Collectors.toMap(p -> new Annotation(ISSUE_FLOW_ANNOTATION_TYPE, false, p.getMessage()), p -> new Position(p.getOffset(), p.getLength())));
    }

    private static void removePreviousAnnotations(IAnnotationModel annotationModel) {
        List<Annotation> existingFlowAnnotations = ShowIssueFlowsMarkerResolver.existingFlowAnnotations(annotationModel);
        if (annotationModel instanceof IAnnotationModelExtension) {
            ((IAnnotationModelExtension)annotationModel).replaceAnnotations(existingFlowAnnotations.toArray(new Annotation[0]), Collections.emptyMap());
        } else {
            existingFlowAnnotations.forEach(arg_0 -> ((IAnnotationModel)annotationModel).removeAnnotation(arg_0));
        }
    }

    public static void removeAnnotations(ITextEditor textEditor) {
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider != null) {
            IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)textEditor.getEditorInput());
            ShowIssueFlowsMarkerResolver.removePreviousAnnotations(annotationModel);
        }
    }

    public static void removeAllAnnotations() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITextEditor textEditor;
            IDocumentProvider documentProvider;
            IEditorReference editorRef = iEditorReferenceArray[n2];
            IEditorPart editorPart = editorRef.getEditor(false);
            if (editorPart != null && editorPart instanceof ITextEditor && (documentProvider = (textEditor = (ITextEditor)editorPart).getDocumentProvider()) != null) {
                IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)textEditor.getEditorInput());
                ShowIssueFlowsMarkerResolver.removePreviousAnnotations(annotationModel);
            }
            ++n2;
        }
    }

    private static List<Annotation> existingFlowAnnotations(IAnnotationModel annotationModel) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        annotationModel.getAnnotationIterator().forEachRemaining(a -> {
            if (ISSUE_FLOW_ANNOTATION_TYPE.equals(a.getType())) {
                result.add((Annotation)a);
            }
        });
        return result;
    }

    public Image getImage() {
        return SonarLintImages.IMG_ISSUE;
    }
}

