/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.job;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.ui.internal.popup.ServerUpdateAvailablePopup;

public class CheckForUpdatesJob
extends Job {
    public CheckForUpdatesJob() {
        super("Check for configuration updates on SonarQube servers");
        this.setPriority(50);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)SonarLintCorePlugin.getServersManager().getServers().size());
            subMonitor.setTaskName("Checking for configuration updates on SonarQube servers");
            for (IServer server : SonarLintCorePlugin.getServersManager().getServers()) {
                subMonitor.subTask("Checking for updates from server '" + server.getId() + "'");
                SubMonitor serverMonitor = subMonitor.newChild(1);
                IStatus status = CheckForUpdatesJob.checkForUpdates(server, serverMonitor);
                if (status.matches(8)) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                serverMonitor.done();
            }
            IStatus iStatus = monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            return iStatus;
        }
        finally {
            this.schedule(86400000L);
        }
    }

    private static IStatus checkForUpdates(IServer server, SubMonitor monitor) {
        if (server.isStorageUpdated()) {
            server.checkForUpdates((IProgressMonitor)monitor);
            if (server.hasUpdates()) {
                Display.getDefault().asyncExec(() -> {
                    ServerUpdateAvailablePopup popup = new ServerUpdateAvailablePopup(Display.getCurrent(), server);
                    popup.create();
                    popup.open();
                });
            }
        }
        return Status.OK_STATUS;
    }
}

