/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.console;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.part.IPageBookViewPage;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;
import org.sonarlint.eclipse.ui.internal.SonarLintUiPlugin;
import org.sonarlint.eclipse.ui.internal.console.RemoveAction;

public class SonarLintConsolePageParticipant
implements IConsolePageParticipant {
    private ShowConsoleAction showOnOutputAction;
    private ConfigureLoggingAction configureLoggingAction;
    private IAction consoleRemoveAction;

    public void init(IPageBookViewPage page, IConsole console) {
        this.consoleRemoveAction = new RemoveAction();
        this.configureLoggingAction = new ConfigureLoggingAction();
        this.showOnOutputAction = new ShowConsoleAction();
        IActionBars actionBars = page.getSite().getActionBars();
        this.configureToolBar(actionBars.getToolBarManager());
    }

    private void configureToolBar(IToolBarManager manager) {
        manager.prependToGroup("launchGroup", this.consoleRemoveAction);
        manager.prependToGroup("outputGroup", (IAction)this.configureLoggingAction);
        manager.appendToGroup("outputGroup", (IAction)this.showOnOutputAction);
    }

    public void dispose() {
        this.configureLoggingAction.dispose();
        this.configureLoggingAction = null;
        this.showOnOutputAction.dispose();
        this.showOnOutputAction = null;
    }

    public void activated() {
    }

    public void deactivated() {
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    static class ConfigureLoggingAction
    extends Action
    implements IMenuCreator {
        private Menu menu;

        public ConfigureLoggingAction() {
            this.setToolTipText(Messages.ConfigureLoggingAction_tooltip);
            this.setImageDescriptor(SonarLintImages.DEBUG);
            this.setMenuCreator(this);
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
            }
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            ConfigureLoggingAction.addActionToMenu(this.menu, new MyAction(Messages.ConfigureLoggingAction_verbose_text, "debugOutput"));
            ConfigureLoggingAction.addActionToMenu(this.menu, new MyAction(Messages.ConfigureLoggingAction_analyzer_text, "showAnalyzerOutput"));
            return this.menu;
        }

        private static void addActionToMenu(Menu parent, Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        static class MyAction
        extends Action {
            private final String propKey;

            public MyAction(String name, String propKey) {
                super(name, 2);
                this.propKey = propKey;
                this.setChecked(MyAction.getPreferenceStore().getBoolean(propKey));
            }

            private static IPreferenceStore getPreferenceStore() {
                return SonarLintUiPlugin.getDefault().getPreferenceStore();
            }

            public void run() {
                MyAction.getPreferenceStore().setValue(this.propKey, this.isChecked());
            }
        }
    }

    static class ShowConsoleAction
    extends Action
    implements IMenuCreator {
        private Menu menu;

        public ShowConsoleAction() {
            this.setToolTipText(Messages.SonarShowConsoleAction_tooltip);
            this.setImageDescriptor(SonarLintImages.SHOW_CONSOLE);
            this.setMenuCreator(this);
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
            }
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            ShowConsoleAction.addActionToMenu(this.menu, new MyAction(Messages.SonarShowConsoleAction_never_text, "never"));
            ShowConsoleAction.addActionToMenu(this.menu, new MyAction(Messages.SonarShowConsoleAction_onOutput_text, "onOutput"));
            ShowConsoleAction.addActionToMenu(this.menu, new MyAction(Messages.SonarShowConsoleAction_onError_text, "onError"));
            return this.menu;
        }

        private static void addActionToMenu(Menu parent, Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        static class MyAction
        extends Action {
            private final String value;

            public MyAction(String name, String value) {
                super(name, 8);
                this.value = value;
                this.setChecked(value.equals(MyAction.getCurrentValue()));
            }

            private static String getCurrentValue() {
                return MyAction.getPreferenceStore().getString("showConsole");
            }

            private static IPreferenceStore getPreferenceStore() {
                return SonarLintUiPlugin.getDefault().getPreferenceStore();
            }

            public void run() {
                MyAction.getPreferenceStore().setValue("showConsole", this.value);
            }
        }
    }
}

