/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.console;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.SonarLintUiPlugin;

public class SonarLintConsole
extends MessageConsole {
    public static final String P_VERBOSE_OUTPUT = "debugOutput";
    public static final String P_ANALYZER_OUTPUT = "showAnalyzerOutput";
    public static final String P_SHOW_CONSOLE = "showConsole";
    public static final String P_SHOW_CONSOLE_NEVER = "never";
    public static final String P_SHOW_CONSOLE_ON_OUTPUT = "onOutput";
    public static final String P_SHOW_CONSOLE_ON_ERROR = "onError";
    public static final String TITLE = Messages.SonarConsole_title;
    private MessageConsoleStream infoStream;
    private MessageConsoleStream warnStream;
    private MessageConsoleStream debugStream;
    private Color warnColor;
    private Color debugColor;

    public SonarLintConsole(ImageDescriptor imageDescriptor) {
        super(TITLE, imageDescriptor);
        Display display = Display.getDefault();
        this.infoStream = this.newMessageStream();
        this.warnStream = this.newMessageStream();
        this.debugStream = this.newMessageStream();
        this.warnColor = new Color((Device)display, new RGB(255, 0, 0));
        this.debugColor = new Color((Device)display, new RGB(0, 0, 255));
        this.getWarnStream().setColor(this.warnColor);
        this.getDebugStream().setColor(this.debugColor);
    }

    public void bringConsoleToFront() {
        if (PlatformUI.isWorkbenchRunning()) {
            IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
            if (!SonarLintConsole.isVisible()) {
                manager.addConsoles(new IConsole[]{this});
            }
            manager.showConsoleView((IConsole)this);
        }
    }

    private static boolean isVisible() {
        IConsoleManager conMan = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (TITLE.equals(existing[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void info(String msg, boolean fromAnalyzer) {
        if (SonarLintConsole.showAnalysisLogs() || !fromAnalyzer) {
            if (SonarLintConsole.isShowConsoleOnOutput()) {
                this.bringConsoleToFront();
            }
            SonarLintConsole.write(this.getInfoStream(), msg);
        }
    }

    public void error(String msg, boolean fromAnalyzer) {
        if (SonarLintConsole.showAnalysisLogs() || !fromAnalyzer) {
            if (SonarLintConsole.isShowConsoleOnOutput() || SonarLintConsole.isShowConsoleOnError()) {
                this.bringConsoleToFront();
            }
            SonarLintConsole.write(this.getWarnStream(), msg);
        }
    }

    public void debug(String msg, boolean fromAnalyzer) {
        if (SonarLintConsole.isVerboseEnabled() && (SonarLintConsole.showAnalysisLogs() || !fromAnalyzer)) {
            if (SonarLintConsole.isShowConsoleOnOutput()) {
                this.bringConsoleToFront();
            }
            SonarLintConsole.write(this.getDebugStream(), msg);
        }
    }

    private static void write(MessageConsoleStream stream, String msg) {
        if (msg == null) {
            return;
        }
        stream.println(msg);
    }

    private MessageConsoleStream getInfoStream() {
        return this.infoStream;
    }

    private MessageConsoleStream getWarnStream() {
        return this.warnStream;
    }

    public MessageConsoleStream getDebugStream() {
        return this.debugStream;
    }

    private static String getShowConsolePreference() {
        return SonarLintUiPlugin.getDefault().getPreferenceStore().getString(P_SHOW_CONSOLE);
    }

    private static boolean isShowConsoleOnOutput() {
        return P_SHOW_CONSOLE_ON_OUTPUT.equals(SonarLintConsole.getShowConsolePreference());
    }

    private static boolean isShowConsoleOnError() {
        return P_SHOW_CONSOLE_ON_ERROR.equals(SonarLintConsole.getShowConsolePreference());
    }

    public static boolean isVerboseEnabled() {
        return SonarLintUiPlugin.getDefault().getPreferenceStore().getBoolean(P_VERBOSE_OUTPUT);
    }

    public static boolean showAnalysisLogs() {
        return SonarLintUiPlugin.getDefault().getPreferenceStore().getBoolean(P_ANALYZER_OUTPUT);
    }
}

