/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.TriggerType;
import org.sonarlint.eclipse.core.internal.jobs.LogListener;
import org.sonarlint.eclipse.core.internal.markers.MarkerUtils;
import org.sonarlint.eclipse.core.internal.notifications.ListenerFactory;
import org.sonarlint.eclipse.core.internal.resources.ProjectsProviderUtils;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.utils.SonarLintUtils;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;
import org.sonarlint.eclipse.ui.internal.SonarLintPartListener;
import org.sonarlint.eclipse.ui.internal.SonarLintPostBuildListener;
import org.sonarlint.eclipse.ui.internal.SonarLintProjectEventListener;
import org.sonarlint.eclipse.ui.internal.console.SonarLintConsole;
import org.sonarlint.eclipse.ui.internal.job.CheckForUpdatesJob;
import org.sonarlint.eclipse.ui.internal.popup.ServerStorageNeedUpdatePopup;
import org.sonarlint.eclipse.ui.internal.popup.SonarQubeNotificationPopup;
import org.sonarlint.eclipse.ui.internal.server.actions.JobUtils;
import org.sonarsource.sonarlint.core.client.api.notifications.SonarQubeNotification;
import org.sonarsource.sonarlint.core.client.api.notifications.SonarQubeNotificationListener;

public class SonarLintUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.sonarlint.eclipse.ui";
    private static SonarLintUiPlugin plugin;
    private IPropertyChangeListener prefListener;
    private LogListener logListener;
    private SonarLintConsole console;
    private ListenerFactory listenerFactory;
    private static final SonarLintPartListener SONARLINT_PART_LISTENER;
    private static final SonarLintPostBuildListener SONARLINT_POST_BUILD_LISTENER;
    private static final SonarLintProjectEventListener SONARLINT_PROJECT_EVENT_LISTENER;

    static {
        SONARLINT_PART_LISTENER = new SonarLintPartListener();
        SONARLINT_POST_BUILD_LISTENER = new SonarLintPostBuildListener();
        SONARLINT_PROJECT_EVENT_LISTENER = new SonarLintProjectEventListener();
    }

    public SonarLintUiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        SonarLintUiPlugin.addChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)SONARLINT_PROJECT_EVENT_LISTENER);
        this.logListener = new SonarLintConsoleLogger();
        SonarLintLogger.get().addLogListener(this.logListener);
        this.prefListener = event -> {
            if (event.getProperty().equals("markerSeverity")) {
                try {
                    MarkerUtils.updateAllSonarMarkerSeverity();
                }
                catch (CoreException e) {
                    SonarLintLogger.get().error("Unable to update marker severity", (Throwable)e);
                }
            }
        };
        this.getPreferenceStore().addPropertyChangeListener(this.prefListener);
        SonarLintLogger.get().info("Starting SonarLint for Eclipse " + SonarLintUtils.getPluginVersion());
        SonarLintUiPlugin.checkServersStatus();
        new CheckForUpdatesJob().schedule(10000L);
        SonarLintUiPlugin.analyzeOpenedFiles();
        SonarLintUiPlugin.subscribeToNotifications();
    }

    private static void checkServersStatus() {
        for (IServer server : SonarLintCorePlugin.getServersManager().getServers()) {
            if (server.isStorageUpdated()) continue;
            Display.getDefault().asyncExec(() -> {
                ServerStorageNeedUpdatePopup popup = new ServerStorageNeedUpdatePopup(Display.getCurrent(), server);
                popup.create();
                popup.open();
            });
        }
    }

    public void stop(BundleContext context) throws Exception {
        SonarLintUiPlugin.removeChangeListener();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)SONARLINT_PROJECT_EVENT_LISTENER);
        SonarLintLogger.get().removeLogListener(this.logListener);
        try {
            this.getPreferenceStore().removePropertyChangeListener(this.prefListener);
        }
        finally {
            super.stop(context);
        }
    }

    public static void addChangeListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)SONARLINT_POST_BUILD_LISTENER, 16);
    }

    public static void removeChangeListener() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)SONARLINT_POST_BUILD_LISTENER);
    }

    public static SonarLintUiPlugin getDefault() {
        return plugin;
    }

    public synchronized SonarLintConsole getSonarConsole() {
        if (this.console != null) {
            return this.console;
        }
        this.console = new SonarLintConsole(SonarLintImages.SONARLINT_CONSOLE_IMG_DESC);
        return this.console;
    }

    public synchronized void closeSonarConsole() {
        if (this.console != null) {
            IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
            manager.removeConsoles(new IConsole[]{this.console});
            this.console = null;
        }
    }

    public synchronized ListenerFactory listenerFactory() {
        if (this.listenerFactory == null) {
            this.listenerFactory = () -> new SonarQubeNotificationListener(){

                public void handle(SonarQubeNotification notification) {
                    Display.getDefault().asyncExec(() -> {
                        SonarQubeNotificationPopup popup = new SonarQubeNotificationPopup(Display.getCurrent(), notification);
                        popup.create();
                        popup.open();
                    });
                }
            };
        }
        return this.listenerFactory;
    }

    public static void analyzeOpenedFiles() {
        new AnalyzeOpenedFilesJob().schedule(2000L);
    }

    private static void subscribeToNotifications() {
        try {
            ProjectsProviderUtils.allProjects().stream().filter(ISonarLintProject::isBound).forEach(SonarLintUiPlugin::subscribeToNotifications);
        }
        catch (IllegalStateException e) {
            SonarLintLogger.get().error("Could not subscribe to notifications", (Throwable)e);
        }
    }

    public static void subscribeToNotifications(ISonarLintProject project) {
        SonarLintCorePlugin.getInstance().notificationsManager().subscribe(project, SonarLintUiPlugin.getDefault().listenerFactory().create());
    }

    public static void unsubscribeToNotifications(ISonarLintProject project) {
        SonarLintCorePlugin.getInstance().notificationsManager().unsubscribe(project);
    }

    private static class AnalyzeOpenedFilesJob
    extends Job {
        AnalyzeOpenedFilesJob() {
            super("Analyze opened files");
        }

        public IStatus run(IProgressMonitor monitor) {
            JobUtils.scheduleAnalysisOfOpenFiles(null, TriggerType.STARTUP);
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                AnalyzeOpenedFilesJob.addListenerToAllPages(window);
                ++n2;
            }
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)new WindowOpenCloseListener());
            return Status.OK_STATUS;
        }

        private static void addListenerToAllPages(IWorkbenchWindow window) {
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n = iWorkbenchPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage page = iWorkbenchPageArray[n2];
                page.addPartListener((IPartListener2)SONARLINT_PART_LISTENER);
                ++n2;
            }
        }

        static class WindowOpenCloseListener
        implements IWindowListener {
            WindowOpenCloseListener() {
            }

            public void windowOpened(IWorkbenchWindow window) {
                AnalyzeOpenedFilesJob.addListenerToAllPages(window);
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
                WindowOpenCloseListener.removeListenerToAllPages(window);
            }

            public void windowActivated(IWorkbenchWindow window) {
            }

            private static void removeListenerToAllPages(IWorkbenchWindow window) {
                IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                int n = iWorkbenchPageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage page = iWorkbenchPageArray[n2];
                    page.removePartListener((IPartListener2)SONARLINT_PART_LISTENER);
                    ++n2;
                }
            }
        }
    }

    private class SonarLintConsoleLogger
    implements LogListener {
        private SonarLintConsoleLogger() {
        }

        public void info(String msg, boolean fromAnalyzer) {
            if (PlatformUI.isWorkbenchRunning()) {
                SonarLintUiPlugin.this.getSonarConsole().info(msg, fromAnalyzer);
            }
        }

        public void error(String msg, boolean fromAnalyzer) {
            if (PlatformUI.isWorkbenchRunning()) {
                SonarLintUiPlugin.this.getSonarConsole().error(msg, fromAnalyzer);
            }
        }

        public void debug(String msg, boolean fromAnalyzer) {
            if (PlatformUI.isWorkbenchRunning()) {
                SonarLintUiPlugin.this.getSonarConsole().debug(msg, fromAnalyzer);
            }
        }
    }
}

