/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal;

import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.adapter.Adapters;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.SonarLintUiPlugin;

public class SonarLintProjectEventListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            try {
                event.getDelta().accept(SonarLintProjectEventListener::visitDelta);
            }
            catch (CoreException e) {
                SonarLintLogger.get().error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static boolean visitDelta(IResourceDelta delta) {
        if ((delta.getFlags() & 0x4000) != 0) {
            ISonarLintProject project = (ISonarLintProject)Adapters.adapt((Object)delta.getResource(), ISonarLintProject.class);
            if (project != null && project.isBound()) {
                if (project.isOpen()) {
                    SonarLintUiPlugin.subscribeToNotifications(project);
                } else {
                    SonarLintCorePlugin.getInstance().notificationsManager().unsubscribe(project);
                }
            }
            return false;
        }
        return true;
    }
}

