/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal;

import java.util.Collection;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.adapter.Adapters;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProjectConfiguration;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;

public class SonarLintProjectDecorator
implements ILightweightLabelDecorator {
    public static final String ID = "org.sonarlint.eclipse.ui.sonarlintDecorator";
    private ListenerList<ILabelProviderListener> fListeners = new ListenerList();

    public void decorate(Object element, IDecoration decoration) {
        ISonarLintProject project = (ISonarLintProject)Adapters.adapt((Object)element, ISonarLintProject.class);
        if (project != null && project.isOpen()) {
            SonarLintProjectConfiguration p = SonarLintProjectConfiguration.read((IScopeContext)project.getScopeContext());
            if (!p.isAutoEnabled()) {
                return;
            }
            if (p.getServerId() != null && SonarLintCorePlugin.getServersManager().getServer(p.getServerId()) != null) {
                decoration.addOverlay(SonarLintImages.SQ_LABEL_DECORATOR);
            }
        }
    }

    public void addListener(ILabelProviderListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void dispose() {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            this.fListeners.remove(listeners[i]);
            ++i;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove((Object)listener);
    }

    public void fireChange(Collection<ISonarLintProject> elements) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, elements.stream().map(ISonarLintProject::getObjectToNotify).toArray());
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ILabelProviderListener)listeners[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }
}

