/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.TriggerType;
import org.sonarlint.eclipse.core.internal.adapter.Adapters;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectJob;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectRequest;
import org.sonarlint.eclipse.core.internal.utils.SonarLintUtils;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;
import org.sonarlint.eclipse.core.resource.ISonarLintIssuable;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.SonarLintUiPlugin;
import org.sonarlint.eclipse.ui.internal.markers.ShowIssueFlowsMarkerResolver;
import org.sonarlint.eclipse.ui.internal.server.actions.JobUtils;
import org.sonarlint.eclipse.ui.internal.util.PlatformUtils;

public class SonarLintPostBuildListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 16) {
            ArrayList changedFiles = new ArrayList();
            try {
                event.getDelta().accept(delta -> SonarLintPostBuildListener.visitDelta(changedFiles, delta));
            }
            catch (CoreException e) {
                SonarLintLogger.get().error(e.getMessage(), (Throwable)e);
            }
            if (!changedFiles.isEmpty()) {
                SonarLintUiPlugin.removeChangeListener();
                AnalyzeOpenedFiles job = new AnalyzeOpenedFiles(changedFiles.stream().collect(Collectors.groupingBy(ISonarLintIssuable::getProject, Collectors.toList())));
                JobUtils.scheduleAfter(job, SonarLintUiPlugin::addChangeListener);
                job.schedule();
            }
        }
    }

    private static boolean visitDelta(Collection<ISonarLintFile> changedFiles, IResourceDelta delta) {
        if (!SonarLintUtils.shouldAnalyze((IResource)delta.getResource())) {
            return false;
        }
        ISonarLintProject sonarLintProject = (ISonarLintProject)Adapters.adapt((Object)delta.getResource(), ISonarLintProject.class);
        if (sonarLintProject != null) {
            return sonarLintProject.isAutoEnabled();
        }
        ISonarLintFile sonarLintFile = (ISonarLintFile)Adapters.adapt((Object)delta.getResource(), ISonarLintFile.class);
        if (sonarLintFile != null && sonarLintFile.getProject().isAutoEnabled() && SonarLintPostBuildListener.isChanged(delta)) {
            changedFiles.add(sonarLintFile);
            return true;
        }
        return true;
    }

    private static boolean isChanged(IResourceDelta delta) {
        return delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0;
    }

    private static class AnalyzeOpenedFiles
    extends Job {
        private final Map<ISonarLintProject, List<ISonarLintFile>> changedFilesPerProject;

        AnalyzeOpenedFiles(Map<ISonarLintProject, List<ISonarLintFile>> changedFilesPerProject) {
            super("Find opened files");
            this.changedFilesPerProject = changedFilesPerProject;
        }

        public IStatus run(IProgressMonitor monitor) {
            for (Map.Entry<ISonarLintProject, List<ISonarLintFile>> entry : this.changedFilesPerProject.entrySet()) {
                ISonarLintProject project = entry.getKey();
                Collection filesToAnalyze = entry.getValue().stream().map(f -> {
                    IEditorPart editorPart = PlatformUtils.findEditor(f);
                    if (editorPart instanceof ITextEditor) {
                        ITextEditor textEditor = (ITextEditor)editorPart;
                        ShowIssueFlowsMarkerResolver.removeAnnotations(textEditor);
                        IDocument doc = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                        return new AnalyzeProjectRequest.FileWithDocument(f, doc);
                    }
                    if (editorPart != null) {
                        return new AnalyzeProjectRequest.FileWithDocument(f, null);
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                if (filesToAnalyze.isEmpty()) continue;
                AnalyzeProjectRequest request = new AnalyzeProjectRequest(project, filesToAnalyze, TriggerType.EDITOR_CHANGE);
                new AnalyzeProjectJob(request).schedule();
            }
            return Status.OK_STATUS;
        }
    }
}

