/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.sonarlint.eclipse.ui.internal.SonarLintUiPlugin;

public final class SonarLintImages {
    private static final URL BASE_URL = SonarLintUiPlugin.getDefault().getBundle().getEntry("/icons/");
    public static final ImageDescriptor SONARWIZBAN_IMG = SonarLintImages.createImageDescriptor("sonarqube-48x200.png");
    public static final ImageDescriptor IMG_WIZBAN_NEW_SERVER = SonarLintImages.createImageDescriptor("new_server_wiz.png");
    public static final ImageDescriptor SONARLINT_CONSOLE_IMG_DESC = SonarLintImages.createImageDescriptor("sonarlint-16x16.png");
    public static final ImageDescriptor UPDATE_IMG = SonarLintImages.createImageDescriptor("update.gif");
    public static final ImageDescriptor SYNCED_IMG = SonarLintImages.createImageDescriptor("synced.gif");
    public static final ImageDescriptor MARK_OCCURENCES_IMG = SonarLintImages.createImageDescriptor("mark_occurrences.png");
    public static final ImageDescriptor WIZ_NEW_SERVER = SonarLintImages.createImageDescriptor("wiz_new_server.gif");
    public static final ImageDescriptor SQ_LABEL_DECORATOR = SonarLintImages.createImageDescriptor("onde-label-decorator.gif");
    public static final Image BALLOON_IMG = SonarLintImages.createImage("sonarlint-16x16.png");
    public static final Image IMG_ISSUE = SonarLintImages.createImage("issue_annotation.png");
    public static final Image IMG_SEVERITY_BLOCKER = SonarLintImages.createImage("severity/blocker.png");
    public static final Image IMG_SEVERITY_CRITICAL = SonarLintImages.createImage("severity/critical.png");
    public static final Image IMG_SEVERITY_MAJOR = SonarLintImages.createImage("severity/major.png");
    public static final Image IMG_SEVERITY_MINOR = SonarLintImages.createImage("severity/minor.png");
    public static final Image IMG_SEVERITY_INFO = SonarLintImages.createImage("severity/info.png");
    public static final Image IMG_TYPE_BUG = SonarLintImages.createImage("type/bug.png");
    public static final Image IMG_TYPE_CODE_SMELL = SonarLintImages.createImage("type/code_smell.png");
    public static final Image IMG_TYPE_VULNERABILITY = SonarLintImages.createImage("type/vulnerability.png");
    public static final Image SONARQUBE_SERVER_ICON_IMG = SonarLintImages.createImage("logo/sonarqube-16px.png");
    public static final Image SONARCLOUD_SERVER_ICON_IMG = SonarLintImages.createImage("logo/sonarcloud-16px.png");
    public static final Image IMG_SONARQUBE_LOGO = SonarLintImages.createImage("logo/sonarqube-black-256px.png");
    public static final Image IMG_SONARCLOUD_LOGO = SonarLintImages.createImage("logo/sonarcloud-black-256px.png");
    public static final Image IMG_OPEN_EXTERNAL = SonarLintImages.createImage("external-link-16.png");
    public static final Image NOTIFICATION_CLOSE = SonarLintImages.createImage("popup/notification-close.gif");
    public static final Image NOTIFICATION_CLOSE_HOVER = SonarLintImages.createImage("popup/notification-close-active.gif");
    public static final ImageDescriptor DEBUG = SonarLintImages.createImageDescriptor("debug.gif");
    public static final ImageDescriptor SHOW_CONSOLE = SonarLintImages.createImageDescriptor("showConsole.gif");

    private SonarLintImages() {
    }

    @CheckForNull
    public static Image getIssueImage(String severity, @Nullable String type) {
        String key = String.valueOf(severity) + "/" + type;
        ImageRegistry imageRegistry = SonarLintImages.getImageRegistry();
        if (imageRegistry != null) {
            Image image = imageRegistry.get(key);
            if (image == null) {
                ImageDescriptor severityImage = SonarLintImages.createImageDescriptor("severity/" + severity.toLowerCase(Locale.ENGLISH) + ".png");
                ImageDescriptor typeImage = null;
                if (type != null) {
                    typeImage = SonarLintImages.createImageDescriptor("type/" + type.toLowerCase(Locale.ENGLISH) + ".png");
                }
                imageRegistry.put(key, (ImageDescriptor)new CompositeSeverityTypeImage(severityImage, typeImage));
            }
            return imageRegistry.get(key);
        }
        return null;
    }

    @CheckForNull
    public static Image getSeverityImage(String severity) {
        return SonarLintImages.createImage("severity/" + severity.toLowerCase(Locale.ENGLISH) + ".png");
    }

    @CheckForNull
    public static Image getTypeImage(String type) {
        return SonarLintImages.createImage("type/" + type.toLowerCase(Locale.ENGLISH) + ".png");
    }

    private static URL getUrl(String key) throws MalformedURLException {
        return new URL(BASE_URL, key);
    }

    private static Image createImage(String key) {
        SonarLintImages.createImageDescriptor(key);
        ImageRegistry imageRegistry = SonarLintImages.getImageRegistry();
        return imageRegistry != null ? imageRegistry.get(key) : null;
    }

    @CheckForNull
    private static ImageDescriptor createImageDescriptor(String key) {
        ImageRegistry imageRegistry = SonarLintImages.getImageRegistry();
        if (imageRegistry != null) {
            ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(key);
            if (imageDescriptor == null) {
                try {
                    imageDescriptor = ImageDescriptor.createFromURL((URL)SonarLintImages.getUrl(key));
                }
                catch (MalformedURLException malformedURLException) {
                    imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
                }
                imageRegistry.put(key, imageDescriptor);
            }
            return imageDescriptor;
        }
        return null;
    }

    @CheckForNull
    private static ImageRegistry getImageRegistry() {
        if (PlatformUI.isWorkbenchRunning()) {
            return SonarLintUiPlugin.getDefault().getImageRegistry();
        }
        return null;
    }

    private static class CompositeSeverityTypeImage
    extends CompositeImageDescriptor {
        private final ImageDescriptor severity;
        private final ImageDescriptor type;

        public CompositeSeverityTypeImage(ImageDescriptor severity, @Nullable ImageDescriptor type) {
            this.severity = severity;
            this.type = type;
        }

        protected void drawCompositeImage(int width, int height) {
            if (this.type != null) {
                this.drawImage(this.type.getImageData(), 0, 0);
                this.drawImage(this.severity.getImageData(), 16, 0);
            } else {
                this.drawImage(this.severity.getImageData(), 0, 0);
            }
        }

        protected Point getSize() {
            return new Point(32, 16);
        }
    }
}

