/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors.webflow.graph;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.springframework.ide.eclipse.config.graph.ScaledImageDescriptor;
import org.springframework.ide.eclipse.config.ui.ConfigUiPlugin;

public class WebFlowImages {
    private static final URL baseURL = ConfigUiPlugin.getDefault().getBundle().getEntry("/icons/");
    private static ImageRegistry imageRegistry;
    private static final double SCALE = 0.5;
    private static final String FLOW = "webflow";
    public static final ImageDescriptor ACTION;
    public static final ImageDescriptor ACTION_SMALL;
    public static final ImageDescriptor DECISION;
    public static final ImageDescriptor DECISION_SMALL;
    public static final ImageDescriptor END;
    public static final ImageDescriptor END_SMALL;
    public static final ImageDescriptor SUBFLOW;
    public static final ImageDescriptor SUBFLOW_SMALL;
    public static final ImageDescriptor VIEW;
    public static final ImageDescriptor VIEW_SMALL;

    static {
        ACTION = WebFlowImages.create(FLOW, "action.png");
        ACTION_SMALL = WebFlowImages.scale(ACTION, 0.5);
        DECISION = WebFlowImages.create(FLOW, "decision.png");
        DECISION_SMALL = WebFlowImages.scale(DECISION, 0.5);
        END = WebFlowImages.create(FLOW, "end.png");
        END_SMALL = WebFlowImages.scale(END, 0.5);
        SUBFLOW = WebFlowImages.create(FLOW, "subflow.png");
        SUBFLOW_SMALL = WebFlowImages.scale(SUBFLOW, 0.5);
        VIEW = WebFlowImages.create(FLOW, "view.png");
        VIEW_SMALL = WebFlowImages.scale(VIEW, 0.5);
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)WebFlowImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }

    private static ImageDescriptor scale(ImageDescriptor descriptor, double scale) {
        String key = "" + descriptor.hashCode();
        key = String.valueOf(key) + new Double(scale).hashCode();
        ImageDescriptor cache = WebFlowImages.getImageRegistry().getDescriptor(key);
        if (cache == null) {
            cache = new ScaledImageDescriptor(descriptor, scale);
            WebFlowImages.getImageRegistry().put(key, cache);
        }
        return cache;
    }
}

