/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.buildship;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.List;
import org.eclipse.buildship.core.projectimport.ProjectImportConfiguration;
import org.eclipse.buildship.core.util.gradle.GradleDistributionWrapper;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.workspace.SynchronizeGradleProjectJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.springframework.ide.eclipse.boot.wizard.content.BuildType;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportConfiguration;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportStrategy;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportStrategyFactory;
import org.springsource.ide.eclipse.commons.core.util.NatureUtils;

public class BuildshipImportStrategy
extends ImportStrategy {
    public BuildshipImportStrategy(BuildType buildType, String name, String notInstalledMessage) {
        super(buildType, name, notInstalledMessage);
    }

    private IProject getProject(File projectLoc) {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f;
            IPath l;
            IProject p = iProjectArray[n2];
            if (p.isAccessible() && (l = this.getLocation(p)) != null && projectLoc.equals(f = l.toFile())) {
                return p;
            }
            ++n2;
        }
        return null;
    }

    private IPath getLocation(IProject p) {
        URI uri = p.getRawLocationURI();
        if (uri == null) {
            IPath wsloc = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            return wsloc.append(p.getName());
        }
        if (uri.getScheme().equals("file")) {
            return new Path(uri.getPath());
        }
        return null;
    }

    public IRunnableWithProgress createOperation(final ImportConfiguration conf) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor mon) throws InvocationTargetException, InterruptedException {
                mon.beginTask("Import Gradle Buildship project", 10);
                try {
                    try {
                        File loc = new File(conf.getLocation());
                        conf.getCodeSet().createAt(loc);
                        ProjectImportConfiguration conf2 = new ProjectImportConfiguration();
                        conf2.setProjectDir(loc);
                        conf2.setGradleDistribution(BuildshipImportStrategy.this.createGradleDistribution());
                        conf2.setApplyWorkingSets(Boolean.valueOf(false));
                        SynchronizeGradleProjectJob job = new SynchronizeGradleProjectJob(conf2.toFixedAttributes(), (List)ImmutableList.of(), AsyncHandler.NO_OP);
                        job.schedule();
                        job.join(0L, (IProgressMonitor)new SubProgressMonitor(mon, 9));
                        IProject p = BuildshipImportStrategy.this.getProject(loc);
                        if (p != null) {
                            NatureUtils.ensure((IProject)p, (IProgressMonitor)new SubProgressMonitor(mon, 1), (String[])new String[]{"org.springframework.ide.eclipse.core.springnature"});
                        }
                    }
                    catch (InterruptedException | InvocationTargetException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    mon.done();
                }
            }
        };
    }

    private GradleDistributionWrapper createGradleDistribution() {
        GradleDistributionWrapper.DistributionType distributionType = GradleDistributionWrapper.DistributionType.WRAPPER;
        String distributionConfiguration = null;
        return GradleDistributionWrapper.from((GradleDistributionWrapper.DistributionType)distributionType, distributionConfiguration);
    }

    public static class Factory
    implements ImportStrategyFactory {
        public ImportStrategy create(BuildType buildType, String name, String notInstalledMessage) throws Exception {
            Assert.isLegal((buildType == BuildType.GRADLE ? 1 : 0) != 0);
            Class.forName("org.eclipse.buildship.core.projectimport.ProjectImportConfiguration");
            return new BuildshipImportStrategy(buildType, name, notInstalledMessage);
        }
    }
}

