/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.configurator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;
import org.springsource.ide.eclipse.commons.configurator.ConfigurableExtension;
import org.springsource.ide.eclipse.commons.configurator.IConfigurationContext;
import org.springsource.ide.eclipse.commons.configurator.WorkspaceConfiguratorParticipant;
import org.springsource.ide.eclipse.commons.internal.configurator.ConfiguratorImporter;
import org.springsource.ide.eclipse.commons.internal.configurator.InstallableItem;

public abstract class WorkspaceLocationConfiguratorParticipant
extends WorkspaceConfiguratorParticipant {
    @Override
    public ConfigurableExtension createExtension(File location, IProgressMonitor monitor) {
        if (this.matches(location)) {
            return this.doCreateExtension(location, monitor);
        }
        return null;
    }

    @Override
    public List<ConfigurableExtension> detectExtensions(IConfigurationContext context, IProgressMonitor monitor) {
        VersionRange versionRange = this.getVersionRangeInternal();
        ArrayList<ConfigurableExtension> extensions = new ArrayList<ConfigurableExtension>();
        String[] stringArray = this.getPaths();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (path != null) {
                List<File> locations = context.scan(path, versionRange);
                for (File location : locations) {
                    ConfigurableExtension extension = this.doCreateExtension(location, monitor);
                    if (extension == null) continue;
                    extensions.add(extension);
                }
            }
            ++n2;
        }
        if (extensions.size() > 0) {
            ((ConfigurableExtension)extensions.get(0)).setAutoConfigurable(true);
        }
        return extensions;
    }

    public String getPath() {
        return null;
    }

    public String[] getPaths() {
        return new String[]{this.getPath()};
    }

    public abstract String getVersionRange();

    public boolean matches(File file) {
        String[] stringArray = this.getPaths();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (this.matches(file, path, this.getVersionRange())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private VersionRange getVersionRangeInternal() {
        String versionRangeString = this.getVersionRange();
        VersionRange versionRange = versionRangeString != null ? new VersionRange(versionRangeString) : VersionRange.emptyRange;
        return versionRange;
    }

    protected abstract ConfigurableExtension doCreateExtension(File var1, IProgressMonitor var2);

    protected boolean matches(File location, String path, String versionRange) {
        Assert.isNotNull((Object)location);
        Assert.isNotNull((Object)path);
        return ConfiguratorImporter.matches(location.getName(), path, versionRange != null ? new VersionRange(versionRange) : VersionRange.emptyRange);
    }

    protected Version getVersion(String name) {
        int i = name.lastIndexOf("-");
        if (i != -1) {
            try {
                return new Version(name.substring(i + 1));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Version.emptyVersion;
    }

    @Override
    public ConfigurableExtension createExtension(InstallableItem item, IProgressMonitor monitor) {
        return null;
    }
}

