/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.ide.eclipse.beans.core.internal.model.Bean;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansComponent;
import org.springframework.ide.eclipse.beans.core.internal.model.ProfileAwareBeansComponent;
import org.springframework.ide.eclipse.beans.core.internal.model.ProfileAwareCompositeComponentDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.UniqueBeanNameGenerator;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.namespaces.IModelElementProvider;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;

public class DefaultModelElementProvider
implements IModelElementProvider {
    @Override
    public ISourceModelElement getElement(IBeansConfig config, ComponentDefinition definition) {
        if (definition instanceof CompositeComponentDefinition || definition.getBeanDefinitions().length > 1) {
            return this.createComponent(config, config, definition);
        }
        return this.createBean(config, definition);
    }

    private IBeansComponent createComponent(IBeansModelElement parent, IBeansConfig config, ComponentDefinition definition) {
        BeansComponent component = null;
        component = definition instanceof ProfileAwareCompositeComponentDefinition ? new ProfileAwareBeansComponent(parent, definition) : new BeansComponent(parent, definition);
        BeanDefinition[] beanDefinitionArray = definition.getBeanDefinitions();
        int n = beanDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            BeanDefinition beanDef = beanDefinitionArray[n2];
            if (beanDef instanceof AbstractBeanDefinition) {
                String beanName = UniqueBeanNameGenerator.generateBeanName(beanDef, config);
                Bean bean = new Bean(component, beanName, null, beanDef);
                component.addBean(bean);
            }
            ++n2;
        }
        if (definition instanceof CompositeComponentDefinition) {
            beanDefinitionArray = ((CompositeComponentDefinition)definition).getNestedComponents();
            n = beanDefinitionArray.length;
            n2 = 0;
            while (n2 < n) {
                BeanDefinition compDef = beanDefinitionArray[n2];
                if (compDef instanceof CompositeComponentDefinition || compDef.getBeanDefinitions().length > 1) {
                    component.addComponent(this.createComponent(component, config, (ComponentDefinition)compDef));
                } else {
                    IBean bean = this.createBean(component, (ComponentDefinition)compDef);
                    if (bean != null) {
                        component.addBean(bean);
                    }
                }
                ++n2;
            }
            this.addImplicitBeans(component, (CompositeComponentDefinition)definition, config);
        }
        return component;
    }

    private void addImplicitBeans(BeansComponent component, CompositeComponentDefinition context, IBeansConfig config) {
        BeanDefinitionRegistry rawBeans = config.getRawBeanDefinitions(context);
        if (rawBeans != null) {
            String[] stringArray = rawBeans.getBeanDefinitionNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String beanName = stringArray[n2];
                if (!component.hasBean(beanName)) {
                    IBean bean = this.createBean(component, beanName, rawBeans.getBeanDefinition(beanName));
                    component.addBean(bean);
                }
                ++n2;
            }
        }
    }

    private IBean createBean(BeansComponent parent, String beanName, BeanDefinition beanDefinition) {
        return new Bean(parent, new BeanDefinitionHolder(beanDefinition, beanName));
    }

    private IBean createBean(IBeansModelElement parent, ComponentDefinition definition) {
        BeanDefinition[] beanDefs = definition.getBeanDefinitions();
        if (beanDefs.length > 0) {
            Object holder = definition instanceof BeanComponentDefinition ? (BeanComponentDefinition)definition : new BeanDefinitionHolder(definition.getBeanDefinitions()[0], definition.getName());
            return new Bean(parent, (BeanDefinitionHolder)holder);
        }
        return null;
    }
}

