/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.cdt.internal;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.sonarlint.eclipse.cdt.internal.BuildWrapperJsonFactory;
import org.sonarlint.eclipse.cdt.internal.ConfiguredFile;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.analysis.IPreAnalysisContext;
import org.sonarlint.eclipse.core.internal.jobs.DefaultPreAnalysisContext;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;

public class CdtUtils {
    private static final String CFAMILY_USE_CACHE = "sonar.cfamily.useCache";
    private static final String BUILD_WRAPPER_OUTPUT_PROP = "sonar.cfamily.build-wrapper-output";
    private static final String BUILD_WRAPPER_OUTPUT_FILENAME = "build-wrapper-dump.json";
    private static final Charset BUILD_WRAPPER_OUTPUT_CHARSET = StandardCharsets.UTF_8;
    private final BuildWrapperJsonFactory jsonFactory;
    private final CCorePlugin cCorePlugin;
    private final Predicate<IFile> fileValidator;
    private final SonarLintLogger logger;
    private final BiFunction<IProject, String, IContentType> contentTypeResolver;

    public CdtUtils() {
        this(new BuildWrapperJsonFactory(), CCorePlugin.getDefault(), CoreModel::isTranslationUnit, CCorePlugin::getContentType, SonarLintLogger.get());
    }

    public CdtUtils(BuildWrapperJsonFactory jsonFactory, CCorePlugin cCorePlugin, Predicate<IFile> fileValidator, BiFunction<IProject, String, IContentType> contentTypeResolver, SonarLintLogger logger) {
        this.jsonFactory = jsonFactory;
        this.cCorePlugin = cCorePlugin;
        this.fileValidator = fileValidator;
        this.logger = logger;
        this.contentTypeResolver = contentTypeResolver;
    }

    public void configure(IPreAnalysisContext context, IProgressMonitor monitor) {
        Collection filesToAnalyze = context.getFilesToAnalyze().stream().filter(f -> f.getResource() instanceof IFile && this.fileValidator.test((IFile)f.getResource())).collect(Collectors.toList());
        try {
            Collection<ConfiguredFile> configuredFiles = this.configureCProject(context, context.getProject(), filesToAnalyze);
            Path jsonPath = this.writeJson(context, context.getProject(), configuredFiles);
            this.logger.debug("Wrote build info to: " + jsonPath.toString());
            context.setAnalysisProperty(CFAMILY_USE_CACHE, Boolean.FALSE.toString());
            context.setAnalysisProperty(BUILD_WRAPPER_OUTPUT_PROP, jsonPath.getParent().toString());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private Collection<ConfiguredFile> configureCProject(IPreAnalysisContext context, ISonarLintProject project, Collection<ISonarLintFile> filesToAnalyze) {
        LinkedList<ConfiguredFile> files = new LinkedList<ConfiguredFile>();
        IScannerInfoProvider infoProvider = this.cCorePlugin.getScannerInfoProvider((IProject)project.getResource());
        for (ISonarLintFile file : filesToAnalyze) {
            ConfiguredFile.Builder builder = new ConfiguredFile.Builder((IFile)file.getResource());
            String path = ((DefaultPreAnalysisContext)context).getLocalPath(file);
            IScannerInfo fileInfo = infoProvider.getScannerInformation(file.getResource());
            builder.includes(fileInfo.getIncludePaths() != null ? fileInfo.getIncludePaths() : new String[]{}).symbols(fileInfo.getDefinedSymbols() != null ? fileInfo.getDefinedSymbols() : Collections.emptyMap()).path(path);
            files.add(builder.build());
        }
        return files;
    }

    private Path writeJson(IPreAnalysisContext context, ISonarLintProject project, Collection<ConfiguredFile> files) throws IOException {
        String json = this.jsonFactory.create(files, CdtUtils.getBaseDir(context, project));
        return CdtUtils.createJsonFile(context.getAnalysisTemporaryFolder(), json);
    }

    private static String getBaseDir(IPreAnalysisContext context, ISonarLintProject project) {
        IPath projectLocation = project.getResource().getLocation();
        if (projectLocation != null) {
            return projectLocation.toFile().toString();
        }
        return context.getAnalysisTemporaryFolder().toString();
    }

    @CheckForNull
    private String getFileLanguage(IProject project, IFile file) {
        IPath location = file.getLocation();
        if (location == null) {
            return null;
        }
        IContentType contentType = this.contentTypeResolver.apply(project, location.toOSString());
        if (contentType == null) {
            return null;
        }
        switch (contentType.getId()) {
            case "org.eclipse.cdt.core.cHeader": 
            case "org.eclipse.cdt.core.cSource": {
                return "c";
            }
            case "org.eclipse.cdt.core.cxxHeader": 
            case "org.eclipse.cdt.core.cxxSource": {
                return "cpp";
            }
        }
        return null;
    }

    private static Path createJsonFile(Path workDir, String content) throws IOException {
        Path jsonFilePath = workDir.resolve(BUILD_WRAPPER_OUTPUT_FILENAME);
        Files.createDirectories(workDir, new FileAttribute[0]);
        Files.write(jsonFilePath, content.getBytes(BUILD_WRAPPER_OUTPUT_CHARSET), new OpenOption[0]);
        return jsonFilePath;
    }

    public String language(IFile iFile) {
        return this.getFileLanguage(iFile.getProject(), iFile);
    }
}

