/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.cdt.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.sonarlint.eclipse.cdt.internal.CdtUtils;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.analysis.IAnalysisConfigurator;
import org.sonarlint.eclipse.core.analysis.IFileLanguageProvider;
import org.sonarlint.eclipse.core.analysis.IPreAnalysisContext;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;

public class CProjectConfiguratorExtension
implements IAnalysisConfigurator,
IFileLanguageProvider {
    private final CdtUtils cdtUtils = CProjectConfiguratorExtension.isCdtPresent() ? new CdtUtils() : null;

    private static boolean isCdtPresent() {
        try {
            Class.forName("org.eclipse.cdt.core.CCorePlugin");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public boolean canConfigure(ISonarLintProject project) {
        try {
            IProject underlyingProject;
            IProject iProject = underlyingProject = project.getResource() instanceof IProject ? (IProject)project.getResource() : null;
            return this.cdtUtils != null && underlyingProject != null && (underlyingProject.hasNature("org.eclipse.cdt.core.cnature") || underlyingProject.hasNature("org.eclipse.cdt.core.ccnature"));
        }
        catch (CoreException e) {
            SonarLintLogger.get().error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void configure(IPreAnalysisContext context, IProgressMonitor monitor) {
        this.cdtUtils.configure(context, monitor);
    }

    public String language(ISonarLintFile file) {
        IFile iFile;
        IFile iFile2 = iFile = file.getResource() instanceof IFile ? (IFile)file.getResource() : null;
        if (this.cdtUtils != null && iFile != null) {
            return this.cdtUtils.language(iFile);
        }
        return null;
    }
}

