/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hyperlink.bean;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.BeanHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.ClassHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.NamespaceHyperlinkDetectorSupport;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.bean.ConstructorArgNameHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.bean.FactoryMethodHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.bean.ImportHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.bean.InitDestroyMethodHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.bean.LookupReplaceMethodHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.bean.PropertyNameHyperlinkCalculator;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class BeansHyperlinkDetector
extends NamespaceHyperlinkDetectorSupport
implements IHyperlinkDetector {
    @Override
    public boolean isLinkableAttr(Attr attr) {
        String attrName = attr.getName();
        if ("http://www.springframework.org/schema/p".equals(attr.getNamespaceURI()) && attrName.endsWith("-ref")) {
            return true;
        }
        if ("http://www.springframework.org/schema/c".equals(attr.getNamespaceURI()) && attrName.endsWith("-ref")) {
            return true;
        }
        return super.isLinkableAttr(attr);
    }

    @Override
    public void init() {
        ClassHyperlinkCalculator javaElement = new ClassHyperlinkCalculator();
        this.registerHyperlinkCalculator("class", javaElement);
        this.registerHyperlinkCalculator("value", javaElement);
        this.registerHyperlinkCalculator("match", javaElement);
        this.registerHyperlinkCalculator("key-type", javaElement);
        this.registerHyperlinkCalculator("value-type", javaElement);
        this.registerHyperlinkCalculator("value", "type", javaElement);
        this.registerHyperlinkCalculator("constructor-arg", "type", javaElement);
        BeanHyperlinkCalculator beanRef = new BeanHyperlinkCalculator();
        this.registerHyperlinkCalculator("parent", beanRef);
        this.registerHyperlinkCalculator("factory-bean", beanRef);
        this.registerHyperlinkCalculator("depends-on", beanRef);
        this.registerHyperlinkCalculator("bean", beanRef);
        this.registerHyperlinkCalculator("local", beanRef);
        this.registerHyperlinkCalculator("parent", beanRef);
        this.registerHyperlinkCalculator("ref", beanRef);
        this.registerHyperlinkCalculator("replacer", beanRef);
        this.registerHyperlinkCalculator("key-ref", beanRef);
        this.registerHyperlinkCalculator("value-ref", beanRef);
        this.registerHyperlinkCalculator("alias", "name", beanRef);
        InitDestroyMethodHyperlinkCalculator initDestroy = new InitDestroyMethodHyperlinkCalculator();
        this.registerHyperlinkCalculator("init-method", initDestroy);
        this.registerHyperlinkCalculator("destroy-method", initDestroy);
        LookupReplaceMethodHyperlinkCalculator lookupReplace = new LookupReplaceMethodHyperlinkCalculator();
        this.registerHyperlinkCalculator("lookup-method", "name", lookupReplace);
        this.registerHyperlinkCalculator("replaced-method", "name", lookupReplace);
        this.registerHyperlinkCalculator("property", "name", new PropertyNameHyperlinkCalculator());
        this.registerHyperlinkCalculator("constructor-arg", "name", new ConstructorArgNameHyperlinkCalculator());
        this.registerHyperlinkCalculator("factory-method", new FactoryMethodHyperlinkCalculator());
        this.registerHyperlinkCalculator("import", "resource", new ImportHyperlinkCalculator());
    }

    @Override
    public IHyperlink createHyperlink(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        IHyperlink hyperlink = super.createHyperlink(name, target, node, parentNode, document, textViewer, hyperlinkRegion, cursor);
        if (hyperlink == null && name != null) {
            String parentName = null;
            if (parentNode != null) {
                parentName = parentNode.getNodeName();
            }
            if (name.endsWith("-ref")) {
                return new BeanHyperlinkCalculator().createHyperlink(parentName, target, node, parentNode, document, textViewer, hyperlinkRegion, cursor);
            }
        }
        return hyperlink;
    }

    @Override
    public IHyperlink[] createHyperlinks(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        IHyperlink[] hyperlink = super.createHyperlinks(name, target, node, parentNode, document, textViewer, hyperlinkRegion, cursor);
        if (hyperlink == null && name != null) {
            String parentName = null;
            if (parentNode != null) {
                parentName = parentNode.getNodeName();
            }
            if (name.endsWith("-ref")) {
                return new BeanHyperlinkCalculator().createHyperlinks(parentName, target, node, parentNode, document, textViewer, hyperlinkRegion, cursor);
            }
        }
        return hyperlink;
    }
}

