/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistProcessor;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.AbstractContentAssistProcessor;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.DefaultContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.DefaultContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.ToolAnnotationContentAssistCalulator;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.INamespaceContentAssistProcessor;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.w3c.dom.Node;

public class DelegatingContentAssistProcessor
extends XMLContentAssistProcessor {
    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest) {
        INamespaceContentAssistProcessor[] processors;
        int proposalCount = 0;
        if (contentAssistRequest.getCompletionProposals() != null) {
            proposalCount = contentAssistRequest.getCompletionProposals().length;
        }
        IDOMNode node = (IDOMNode)contentAssistRequest.getNode();
        String namespace = node.getNamespaceURI();
        INamespaceContentAssistProcessor[] iNamespaceContentAssistProcessorArray = processors = NamespaceUtils.getContentAssistProcessor(namespace);
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            INamespaceContentAssistProcessor processor = iNamespaceContentAssistProcessorArray[n2];
            processor.addAttributeValueProposals((IContentAssistProcessor)this, contentAssistRequest);
            ++n2;
        }
        if (contentAssistRequest.getCompletionProposals() == null || contentAssistRequest.getCompletionProposals().length == proposalCount) {
            new ToolAnnotationContentAssistProcessor().addAttributeValueProposals((IContentAssistProcessor)this, contentAssistRequest);
        }
        super.addAttributeValueProposals(contentAssistRequest);
    }

    protected void addAttributeNameProposals(ContentAssistRequest request) {
        INamespaceContentAssistProcessor[] processors;
        IDOMNode node = (IDOMNode)request.getNode();
        String namespace = node.getNamespaceURI();
        INamespaceContentAssistProcessor[] iNamespaceContentAssistProcessorArray = processors = NamespaceUtils.getContentAssistProcessor(namespace);
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            INamespaceContentAssistProcessor processor = iNamespaceContentAssistProcessorArray[n2];
            processor.addAttributeNameProposals((IContentAssistProcessor)this, request);
            ++n2;
        }
        super.addAttributeNameProposals(request);
    }

    protected void addTagCloseProposals(ContentAssistRequest request) {
        INamespaceContentAssistProcessor[] processors;
        IDOMNode node = (IDOMNode)request.getNode();
        String namespace = node.getNamespaceURI();
        INamespaceContentAssistProcessor[] iNamespaceContentAssistProcessorArray = processors = NamespaceUtils.getContentAssistProcessor(namespace);
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            INamespaceContentAssistProcessor processor = iNamespaceContentAssistProcessorArray[n2];
            processor.addTagCloseProposals((IContentAssistProcessor)this, request);
            ++n2;
        }
        super.addTagCloseProposals(request);
    }

    protected void addTagInsertionProposals(ContentAssistRequest request, int childPosition) {
        INamespaceContentAssistProcessor[] processors;
        IDOMNode node = (IDOMNode)request.getNode();
        String namespace = node.getNamespaceURI();
        INamespaceContentAssistProcessor[] iNamespaceContentAssistProcessorArray = processors = NamespaceUtils.getContentAssistProcessor(namespace);
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            INamespaceContentAssistProcessor processor = iNamespaceContentAssistProcessorArray[n2];
            processor.addTagInsertionProposals((IContentAssistProcessor)this, request, childPosition);
            ++n2;
        }
        super.addTagInsertionProposals(request, childPosition);
        this.filterTagInsertionProposals(request);
    }

    private void filterTagInsertionProposals(ContentAssistRequest request) {
        List proposals = request.getProposals();
        Iterator iter = proposals.iterator();
        while (iter.hasNext()) {
            TemplateProposal proposal;
            String display;
            Object obj = iter.next();
            if (!(obj instanceof TemplateProposal) || !(display = (proposal = (TemplateProposal)obj).getDisplayString()).startsWith("dispatcherservlet") && !display.startsWith("contextloaderlistener")) continue;
            iter.remove();
        }
    }

    public ITextViewer getTextViewer() {
        return this.fTextViewer;
    }

    private static class ToolAnnotationContentAssistProcessor
    extends AbstractContentAssistProcessor {
        private final ToolAnnotationContentAssistCalulator calculator = new ToolAnnotationContentAssistCalulator();

        private ToolAnnotationContentAssistProcessor() {
        }

        @Override
        protected void computeAttributeNameProposals(ContentAssistRequest request, String prefix, String namespace, String namespacePrefix, Node attributeNode) {
        }

        @Override
        protected void computeAttributeValueProposals(ContentAssistRequest request, IDOMNode node, String matchString, String attributeName, String namespace, String prefix) {
            DefaultContentAssistContext context = new DefaultContentAssistContext(request, attributeName, BeansEditorUtils.prepareMatchString(matchString));
            DefaultContentAssistProposalRecorder recorder = new DefaultContentAssistProposalRecorder(request);
            this.calculator.computeProposals(context, recorder);
        }

        @Override
        protected void computeTagInsertionProposals(ContentAssistRequest request, IDOMNode node) {
        }
    }
}

