/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.properties;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.UIJob;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.locate.BeansConfigLocatorFactory;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelDecorator;
import org.springframework.ide.eclipse.beans.ui.properties.ConfigFilesTab;
import org.springframework.ide.eclipse.beans.ui.properties.ConfigLocatorTab;
import org.springframework.ide.eclipse.beans.ui.properties.ConfigSetsTab;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesModel;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesProject;
import org.springframework.ide.eclipse.core.MarkerUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springsource.ide.eclipse.commons.core.SpringCorePreferences;

public class ProjectPropertyPage
extends PropertyPage {
    public static final String ID = "org.springframework.ide.eclipse.beans.ui.properties.ProjectPropertyPage";
    public static final String BLOCK_ID = "org.springframework.ide.eclipse.beans.ui.properties.ProjectPropertyPage.blockId";
    public static final String SCAN = "org.springframework.ide.eclipse.beans.ui.properties.ProjectPropertyPage.scan";
    public static final String SELECTED_RESOURCE = "org.springframework.ide.eclipse.beans.ui.properties.ProjectPropertyPage.selectedResource";
    private static final String PREFIX = "ConfigurationPropertyPage.";
    private static final String TITLE = "ConfigurationPropertyPage.title";
    private static final String CONFIG_FILES_LABEL = "ConfigurationPropertyPage.tabConfigFiles.label";
    private static final String CONFIG_SETS_LABEL = "ConfigurationPropertyPage.tabConfigSets.label";
    private static final String CONFIG_LOCATORS_LABEL = "ConfigurationPropertyPage.tabConfigLocators.label";
    private PropertiesModel model;
    private ConfigFilesTab configFilesTab;
    private ConfigSetsTab configSetsTab;
    private int selectedTab;
    private IModelElement selectedModelElement;
    private Map<String, Object> pageData;
    private ConfigLocatorTab configLocatorTab;
    private boolean shouldTriggerScan = false;
    private AtomicBoolean contentCreated = new AtomicBoolean(false);
    private static long INIT_TIMEOUT = 40000L;
    private static long INIT_WAIT_PERIOD = 300L;

    public ProjectPropertyPage() {
        this(null, 0);
    }

    public ProjectPropertyPage(IProject project) {
        this(project, 0);
    }

    public ProjectPropertyPage(IProject project, int selectedTab) {
        this.setElement((IAdaptable)project);
        this.setTitle(BeansUIPlugin.getResourceString(TITLE));
        this.noDefaultAndApplyButton();
        this.selectedTab = selectedTab;
    }

    protected Control createContents(Composite parent) {
        final Composite contents = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)contents);
        contents.setLayout((Layout)new GridLayout());
        final CLabel statusLabel = new CLabel(contents, 0);
        statusLabel.setText("Initializing Beans model, please wait...");
        statusLabel.setImage(JFaceResources.getImage((String)"dialog_messasge_info_image"));
        GridDataFactory.fillDefaults().grab(true, false).exclude(false).applyTo((Control)statusLabel);
        final TabFolder folder = new TabFolder(contents, 0);
        GridDataFactory.fillDefaults().grab(true, true).exclude(true).applyTo((Control)folder);
        final Display display = parent.getDisplay();
        new Job("Wait for bean model initialization"){

            protected IStatus run(IProgressMonitor arg0) {
                final IProject project = (IProject)ProjectPropertyPage.this.getElement();
                ProjectPropertyPage.this.model = new PropertiesModel();
                PropertiesProject mp = null;
                long waitTime = 0L;
                while (waitTime < INIT_TIMEOUT && mp == null) {
                    if (BeansCorePlugin.getModel().isInitialized()) {
                        mp = new PropertiesProject(ProjectPropertyPage.this.model, BeansCorePlugin.getModel().getProject(project));
                        ProjectPropertyPage.this.model.addProject(mp);
                    } else {
                        try {
                            Thread.sleep(INIT_WAIT_PERIOD);
                        }
                        catch (InterruptedException e) {
                            new UIJob("Show error on property page"){

                                public IStatus runInUIThread(IProgressMonitor arg0) {
                                    if (!statusLabel.isDisposed()) {
                                        statusLabel.setText("Failed to wait for Beans model initialization.");
                                        statusLabel.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
                                    }
                                    return Status.OK_STATUS;
                                }
                            }.schedule();
                            return new Status(4, "org.springframework.ide.eclipse.beans.ui", "Failed to initialize preference page content", (Throwable)e);
                        }
                    }
                    waitTime += INIT_WAIT_PERIOD;
                }
                final PropertiesProject modelProject = mp;
                new UIJob(display, "Create Preference Page Content"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (modelProject == null) {
                            if (!statusLabel.isDisposed()) {
                                statusLabel.setText("Timed out waiting for Beans model initialization.");
                                statusLabel.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
                            }
                        } else if (!folder.isDisposed()) {
                            ProjectPropertyPage.this.configFilesTab = new ConfigFilesTab(ProjectPropertyPage.this.model, modelProject, ProjectPropertyPage.this.selectedModelElement);
                            TabItem item = new TabItem(folder, 0);
                            item.setText(BeansUIPlugin.getResourceString(ProjectPropertyPage.CONFIG_FILES_LABEL));
                            item.setControl(ProjectPropertyPage.this.configFilesTab.createControl((Composite)folder));
                            ProjectPropertyPage.this.configSetsTab = new ConfigSetsTab(ProjectPropertyPage.this.model, modelProject, ProjectPropertyPage.this.selectedModelElement);
                            item = new TabItem(folder, 0);
                            item.setText(BeansUIPlugin.getResourceString(ProjectPropertyPage.CONFIG_SETS_LABEL));
                            item.setControl(ProjectPropertyPage.this.configSetsTab.createControl((Composite)folder));
                            if (BeansConfigLocatorFactory.hasEnabledBeansConfigLocatorDefinitions((IProject)project)) {
                                ProjectPropertyPage.this.configLocatorTab = new ConfigLocatorTab(modelProject.getProject());
                                item = new TabItem(folder, 0);
                                item.setText(BeansUIPlugin.getResourceString(ProjectPropertyPage.CONFIG_LOCATORS_LABEL));
                                item.setControl(ProjectPropertyPage.this.configLocatorTab.createContents((Composite)folder));
                            }
                            Dialog.applyDialogFont((Control)folder);
                            folder.setSelection(ProjectPropertyPage.this.selectedTab);
                            if (ProjectPropertyPage.this.shouldTriggerScan) {
                                ProjectPropertyPage.this.configFilesTab.handleScanButtonPressed();
                            }
                            folder.addDisposeListener(new DisposeListener(){

                                public void widgetDisposed(DisposeEvent arg0) {
                                    if (ProjectPropertyPage.this.configFilesTab != null) {
                                        ProjectPropertyPage.this.configFilesTab.dispose();
                                    }
                                    if (ProjectPropertyPage.this.configSetsTab != null) {
                                        ProjectPropertyPage.this.configSetsTab.dispose();
                                    }
                                }
                            });
                            statusLabel.dispose();
                            GridDataFactory.fillDefaults().grab(true, true).exclude(false).applyTo((Control)folder);
                            contents.layout();
                            Composite c = contents.getParent();
                            while (c != null && !(c instanceof ScrolledComposite)) {
                                c = c.getParent();
                            }
                            if (c != null) {
                                ScrolledComposite sc = (ScrolledComposite)c;
                                sc.setMinSize(ProjectPropertyPage.this.getControl().computeSize(-1, -1));
                            }
                            ProjectPropertyPage.this.getControl().getShell().pack();
                            ProjectPropertyPage.this.contentCreated.set(true);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
                return Status.OK_STATUS;
            }
        }.schedule();
        return contents;
    }

    public boolean performOk() {
        if (this.contentCreated.get()) {
            IProject project = (IProject)this.getElement();
            IBeansProject currentProject = BeansCorePlugin.getModel().getProject(project);
            boolean userMadeChanges = this.configFilesTab.hasUserMadeChanges() || this.configSetsTab.hasUserMadeChanges();
            PropertiesProject newProject = (PropertiesProject)this.model.getProject(project);
            if (this.configFilesTab.hasUserMadeChanges()) {
                for (IBeansConfig currentConfig : currentProject.getConfigs()) {
                    if (newProject.hasConfig(currentConfig.getElementName())) continue;
                    MarkerUtils.deleteAllMarkers((IResource)currentConfig.getElementResource(), (String)"org.springframework.ide.eclipse.core.problemmarker");
                }
            }
            if (userMadeChanges) {
                SpringCorePreferences.getProjectPreferences((IProject)project.getProject(), (String)"org.springframework.ide.eclipse.beans.core").putBoolean("ignoreMissingNamespaceHandler", this.configFilesTab.shouldIgnoreMissingNamespaceHandler());
                newProject.saveDescription();
            }
            if (this.configLocatorTab != null) {
                this.configLocatorTab.performOk();
            }
            if (this.configFilesTab.hasUserMadeChanges()) {
                BeansModelLabelDecorator.update();
            }
        }
        return super.performOk();
    }

    public void applyData(Object data) {
        super.applyData(data);
        if (data instanceof Map) {
            this.pageData = (Map)data;
            if (this.pageData.containsKey(BLOCK_ID)) {
                this.selectedTab = (Integer)this.pageData.get(BLOCK_ID);
            }
            if (this.pageData.containsKey(SELECTED_RESOURCE) && this.pageData.get(SELECTED_RESOURCE) instanceof IModelElement) {
                this.selectedModelElement = (IModelElement)this.pageData.get(SELECTED_RESOURCE);
            }
            if (this.pageData.containsKey(SCAN) && this.pageData.get(SCAN) instanceof Boolean) {
                this.shouldTriggerScan = (Boolean)this.pageData.get(SCAN);
            }
        }
    }
}

