/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.navigator.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataNode;
import org.springframework.ide.eclipse.core.io.FileResource;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.ui.SpringUIUtils;
import org.springframework.ide.eclipse.ui.navigator.actions.AbstractNavigatorAction;

public class OpenJavaElementAction
extends AbstractNavigatorAction {
    private Object element;

    public OpenJavaElementAction(ICommonActionExtensionSite site) {
        super(site);
        this.setText("Open Java &Element");
    }

    public boolean isEnabled(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object sElement = selection.getFirstElement();
            if (sElement instanceof IBean || sElement instanceof IBeanProperty) {
                this.element = (ISourceModelElement)sElement;
                return true;
            }
            if (sElement instanceof IJavaElement) {
                this.element = sElement;
                return true;
            }
            if (sElement instanceof BeanMetadataNode) {
                this.element = ((BeanMetadataNode)sElement).getLocation();
                return true;
            }
        }
        return false;
    }

    public final void run() {
        Object javaElement = this.element instanceof IBean ? BeansModelUtils.getBeanType((IBean)((IBean)this.element), null) : (this.element instanceof IBeanProperty ? BeansModelUtils.getPropertyMethod((IBeanProperty)((IBeanProperty)this.element), null) : (this.element instanceof IJavaElement ? (IJavaElement)this.element : null));
        if (javaElement != null) {
            SpringUIUtils.openInEditor((IJavaElement)javaElement);
        }
        if (this.element instanceof IModelSourceLocation) {
            IModelSourceLocation location = (IModelSourceLocation)this.element;
            FileResource fileResource = (FileResource)((IModelSourceLocation)this.element).getResource();
            if (fileResource != null) {
                SpringUIUtils.openInEditor((IFile)fileResource.getRawFile(), (int)location.getStartLine(), (boolean)true);
            }
        }
    }
}

