/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.model;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanClassReferences;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadata;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataNode;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataReference;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataUtils;
import org.springframework.ide.eclipse.beans.ui.namespaces.DefaultNamespaceContentProvider;
import org.springframework.ide.eclipse.beans.ui.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.model.IModelChangeListener;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;

public class BeansModelContentProvider
implements ITreeContentProvider,
ITreePathContentProvider,
IModelChangeListener {
    public static final DefaultNamespaceContentProvider DEFAULT_NAMESPACE_CONTENT_PROVIDER = new DefaultNamespaceContentProvider();
    private final boolean refresh;
    private TreeViewer viewer;

    public BeansModelContentProvider() {
        this(true);
    }

    public BeansModelContentProvider(boolean refresh) {
        this.refresh = refresh;
        if (refresh) {
            BeansCorePlugin.getModel().addChangeListener((IModelChangeListener)this);
        }
    }

    public final void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer instanceof TreeViewer ? (TreeViewer)viewer : null;
    }

    public final void dispose() {
        if (this.refresh) {
            BeansCorePlugin.getModel().removeChangeListener((IModelChangeListener)this);
        }
    }

    public Object[] getElements(Object inputElement) {
        return BeansCorePlugin.getModel().getElementChildren();
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ISourceModelElement) {
            ITreeContentProvider provider = NamespaceUtils.getContentProvider((ISourceModelElement)element);
            if (provider != null) {
                return provider.hasChildren(element);
            }
            return DEFAULT_NAMESPACE_CONTENT_PROVIDER.hasChildren(element);
        }
        if (element instanceof IModelElement) {
            return ((IModelElement)element).getElementChildren().length > 0;
        }
        if (element instanceof IFile) {
            IBeansConfig config = BeansCorePlugin.getModel().getConfig((IFile)element);
            if (config != null) {
                return true;
            }
        } else if (element instanceof ZipEntryStorage) {
            IBeansConfig config = BeansModelUtils.getConfig((ZipEntryStorage)((ZipEntryStorage)element));
            if (config != null) {
                return true;
            }
        } else if (element instanceof IType) {
            IBeansProject beansProject;
            IType type = (IType)element;
            if (!type.isBinary() && (beansProject = BeansCorePlugin.getModel().getProject(type.getJavaProject().getProject())) != null) {
                Set beans = beansProject.getBeans(type.getFullyQualifiedName());
                return beans != null && beans.size() > 0;
            }
        } else if (element instanceof BeanClassReferences) {
            return true;
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IBeanMetadata && BeanMetadataUtils.getContenProvider((IBeanMetadata)parentElement) != null) {
            return BeanMetadataUtils.getContenProvider((IBeanMetadata)parentElement).getChildren(parentElement);
        }
        if (parentElement instanceof BeanMetadataNode) {
            return ((BeanMetadataNode)parentElement).getChildren();
        }
        if (parentElement instanceof ISourceModelElement) {
            ITreeContentProvider provider = NamespaceUtils.getContentProvider((ISourceModelElement)parentElement);
            if (provider != null) {
                return provider.getChildren(parentElement);
            }
            return DEFAULT_NAMESPACE_CONTENT_PROVIDER.getChildren(parentElement);
        }
        if (parentElement instanceof IModelElement) {
            if (parentElement instanceof IBeansProject) {
                return this.getProjectChildren((IBeansProject)parentElement, false);
            }
            if (parentElement instanceof IBeansConfigSet) {
                return this.getConfigSetChildren((IBeansConfigSet)parentElement);
            }
            if (parentElement instanceof IBeansConfig) {
                return ((IBeansConfig)parentElement).getComponents().toArray();
            }
            return ((IModelElement)parentElement).getElementChildren();
        }
        if (parentElement instanceof IFile) {
            IBeansConfig config = BeansCorePlugin.getModel().getConfig((IFile)parentElement);
            if (config != null) {
                return config.getComponents().toArray();
            }
        } else if (parentElement instanceof ZipEntryStorage) {
            IResourceModelElement parent = (IResourceModelElement)((ZipEntryStorage)parentElement).getAdapter(IResourceModelElement.class);
            if (parent instanceof IBeansConfig) {
                return new Object[]{parent};
            }
        } else {
            if (parentElement instanceof IType) {
                return this.getJavaTypeChildren((IType)parentElement);
            }
            if (parentElement instanceof BeanClassReferences) {
                Set beans = ((BeanClassReferences)parentElement).getBeans();
                return beans.toArray(new IBean[beans.size()]);
            }
            if (parentElement instanceof BeanMetadataReference) {
                return ((BeanMetadataReference)parentElement).getChildren();
            }
        }
        return IModelElement.NO_CHILDREN;
    }

    protected Object[] getProjectChildren(IBeansProject project, boolean onlyConfigSets) {
        LinkedHashSet<? extends Object> children = new LinkedHashSet<Object>();
        if (!onlyConfigSets) {
            for (IBeansConfig config : project.getConfigs()) {
                if (config.isElementArchived()) {
                    children.add(new ZipEntryStorage((IResourceModelElement)config));
                    continue;
                }
                children.add(config);
            }
        }
        children.addAll(project.getConfigSets());
        children.addAll(BeanMetadataUtils.getProjectChildren(project));
        return children.toArray();
    }

    protected Object[] getConfigSetChildren(IBeansConfigSet configSet) {
        LinkedHashSet<ISourceModelElement> children = new LinkedHashSet<ISourceModelElement>();
        for (IBeansConfig config : configSet.getConfigs()) {
            this.getConfigChildren(children, config);
        }
        return children.toArray();
    }

    protected void getConfigChildren(Set<ISourceModelElement> children, IBeansConfig config) {
        Object[] configChildren;
        Object[] objectArray = configChildren = this.getChildren(config);
        int n = configChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof IBean || child instanceof IBeansComponent) {
                children.add((ISourceModelElement)child);
            } else if (child instanceof IBeansImport) {
                for (IBeansConfig importedConfig : ((IBeansImport)child).getImportedBeansConfigs()) {
                    this.getConfigChildren(children, importedConfig);
                }
            }
            ++n2;
        }
    }

    protected Object[] getJavaTypeChildren(IType type) {
        Set beans;
        IBeansProject project = BeansCorePlugin.getModel().getProject(type.getJavaProject().getProject());
        if (project != null && (beans = project.getBeans(type.getFullyQualifiedName())) != null && beans.size() > 0) {
            return new Object[]{new BeanClassReferences(type, beans)};
        }
        return IModelElement.NO_CHILDREN;
    }

    public Object getParent(Object element) {
        if (element instanceof ISourceModelElement) {
            ITreeContentProvider provider = NamespaceUtils.getContentProvider((ISourceModelElement)element);
            if (provider != null) {
                return provider.getParent(element);
            }
            return DEFAULT_NAMESPACE_CONTENT_PROVIDER.getParent(element);
        }
        if (element instanceof IModelElement) {
            if (element instanceof IBeansConfig || element instanceof IBeansProject) {
                return ((IResourceModelElement)element).getElementResource();
            }
        } else if (element instanceof IFile) {
            IBeansConfig config = BeansCorePlugin.getModel().getConfig((IFile)element);
            if (config != null) {
                return config.getElementParent();
            }
        } else if (element instanceof ZipEntryStorage) {
            IBeansConfig config = BeansCorePlugin.getModel().getConfig(((ZipEntryStorage)element).getFullName());
            if (config != null) {
                return config.getElementParent();
            }
        } else {
            if (element instanceof BeanClassReferences) {
                return ((BeanClassReferences)element).getBeanClass();
            }
            if (element instanceof BeanMetadataReference) {
                return ((BeanMetadataReference)element).getBeansProject();
            }
        }
        return null;
    }

    public void elementChanged(ModelChangeEvent event) {
        IModelElement element = event.getElement();
        if (event.getType() == ModelChangeEvent.Type.CHANGED) {
            this.refreshViewerForElement(element);
        } else {
            this.refreshViewerForElement(element.getElementParent());
        }
    }

    protected final StructuredViewer getViewer() {
        return this.viewer;
    }

    protected final void refreshViewerForElement(final Object element) {
        if (this.viewer instanceof TreeViewer && element != null) {
            Control ctrl = this.viewer.getControl();
            if (ctrl == null || ctrl.isDisposed()) {
                return;
            }
            if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
                this.refreshRetainingExpansion(element);
            } else {
                ctrl.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Control ctrl = BeansModelContentProvider.this.viewer.getControl();
                        if (ctrl == null || ctrl.isDisposed()) {
                            return;
                        }
                        if (element instanceof IBeansModel) {
                            BeansModelContentProvider.this.refreshRetainingExpansion(element);
                        } else {
                            BeansModelContentProvider.this.refreshRetainingExpansion(element);
                        }
                    }
                });
            }
        }
    }

    private void refreshRetainingExpansion(Object element) {
        Object[] expandedElements = this.viewer.getExpandedElements();
        this.viewer.refresh(element);
        this.viewer.setExpandedElements(expandedElements);
    }

    public Object[] getChildren(TreePath parentPath) {
        if (parentPath == null) {
            return new Object[0];
        }
        if (parentPath.getParentPath() != null && parentPath.getParentPath().getLastSegment() instanceof IBeansImport && parentPath.getLastSegment() instanceof IFile) {
            IFile file = (IFile)parentPath.getLastSegment();
            IBeansImport beansImport = (IBeansImport)parentPath.getParentPath().getLastSegment();
            Set importedConfigs = beansImport.getImportedBeansConfigs();
            for (IBeansConfig bc : importedConfigs) {
                if (!bc.getElementResource().equals((Object)file)) continue;
                return new Object[]{bc};
            }
        }
        return this.getChildren(parentPath.getLastSegment());
    }

    public TreePath[] getParents(Object element) {
        return new TreePath[0];
    }

    public boolean hasChildren(TreePath path) {
        Object[] children = this.getChildren(path);
        return children != null && children.length > 0;
    }
}

