/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.properties.FilePropertySource;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.ResourcePropertySource;
import org.springframework.core.io.Resource;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.AbstractBeansConfig;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanClassReferences;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUIActivationHistory;
import org.springframework.ide.eclipse.beans.ui.model.properties.ChildBeanProperties;
import org.springframework.ide.eclipse.beans.ui.model.properties.ConfigSetProperties;
import org.springframework.ide.eclipse.beans.ui.model.properties.ConstructorArgumentProperties;
import org.springframework.ide.eclipse.beans.ui.model.properties.PropertyProperties;
import org.springframework.ide.eclipse.beans.ui.model.properties.RootBeanProperties;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.ui.TreePathBuilder;
import org.springframework.ide.eclipse.ui.editors.ZipEntryEditorInput;
import org.springsource.ide.eclipse.commons.ui.SpringUIUtils;
import org.w3c.dom.Element;

public final class BeansUIUtils {
    public static IFile getConfigFile(IWorkbenchPart part) {
        IEditorInput input;
        if (part instanceof IEditorPart && (input = ((IEditorPart)part).getEditorInput()) instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            IBeansProject project = BeansCorePlugin.getModel().getProject(file.getProject());
            if (project != null && project.getConfig(file, true) != null) {
                return file;
            }
        }
        return null;
    }

    public static IBeansConfig getConfig(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)part).getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                return BeansCorePlugin.getModel().getConfig(file);
            }
            if (input instanceof ZipEntryEditorInput) {
                ZipEntryStorage storage = (ZipEntryStorage)((ZipEntryEditorInput)input).getStorage();
                IBeansProject project = BeansCorePlugin.getModel().getProject(storage.getFile().getProject());
                if (project != null) {
                    return project.getConfig(storage.getFullName());
                }
            }
        }
        return null;
    }

    public static IPropertySource getPropertySource(String id) {
        IModelElement element = BeansCorePlugin.getModel().getElement(id);
        return element != null ? BeansUIUtils.getPropertySource(element) : null;
    }

    public static IPropertySource getPropertySource(IModelElement element) {
        if (element instanceof IBeansProject) {
            return new ResourcePropertySource((IResource)((IBeansProject)element).getProject());
        }
        if (element instanceof IBeansConfig) {
            IFile file = (IFile)((IBeansConfig)element).getElementResource();
            if (file != null && file.exists()) {
                return new FilePropertySource(file);
            }
        } else {
            if (element instanceof IBeansConfigSet) {
                return new ConfigSetProperties((IBeansConfigSet)element);
            }
            if (element instanceof IBean) {
                IBean bean = (IBean)element;
                if (bean.isRootBean()) {
                    return new RootBeanProperties(bean);
                }
                if (bean.isChildBean()) {
                    return new ChildBeanProperties(bean);
                }
            } else {
                if (element instanceof IBeanConstructorArgument) {
                    return new ConstructorArgumentProperties((IBeanConstructorArgument)element);
                }
                if (element instanceof IBeanProperty) {
                    return new PropertyProperties((IBeanProperty)element);
                }
                boolean cfr_ignored_0 = element instanceof BeanClassReferences;
            }
        }
        return null;
    }

    public static void showProjectPropertyPage(IProject project, Map<String, Object> data) {
        if (project != null) {
            SpringUIUtils.showPreferenceDialog((String)"org.springframework.ide.eclipse.beans.ui.properties.ProjectPropertyPage", (IProject)project, data);
        }
    }

    public static IEditorPart openInEditor(IResourceModelElement element) {
        return BeansUIUtils.openInEditor(element, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IEditorPart openInEditor(IResourceModelElement element, boolean activate) {
        int line;
        IResourceModelElement sourceElement;
        IResource resource = null;
        ZipEntryStorage zipEntryStorage = null;
        if (element instanceof ISourceModelElement) {
            ISourceModelElement source = (ISourceModelElement)element;
            sourceElement = source.getElementSourceElement();
            line = source.getElementStartLine();
            Resource res = source.getElementSourceLocation().getResource();
            if (res instanceof IAdaptable) {
                resource = (IResource)((IAdaptable)res).getAdapter(IResource.class);
                zipEntryStorage = (ZipEntryStorage)((IAdaptable)res).getAdapter(ZipEntryStorage.class);
            } else {
                resource = sourceElement.getElementResource();
            }
        } else {
            if (!(element instanceof AbstractBeansConfig)) return null;
            sourceElement = element;
            line = ((AbstractBeansConfig)element).getElementStartLine();
            resource = sourceElement.getElementResource();
        }
        if (resource instanceof IFile) {
            BeansUIActivationHistory.addToHistory((IModelElement)element);
            IFile file = (IFile)resource;
            if (!sourceElement.isElementArchived()) return SpringUIUtils.openInEditor((IFile)file, (int)line, (boolean)activate);
            try {
                ZipEntryStorage storage = new ZipEntryStorage(sourceElement);
                return BeansUIUtils.openZipEntryStorage(line, file, storage);
            }
            catch (CoreException e) {
                BeansCorePlugin.log((Throwable)e);
                return null;
            }
        } else {
            if (zipEntryStorage == null) return null;
            try {
                return BeansUIUtils.openZipEntryStorage(line, zipEntryStorage.getFile(), zipEntryStorage);
            }
            catch (CoreException e) {
                BeansCorePlugin.log((Throwable)e);
            }
        }
        return null;
    }

    private static IEditorPart openZipEntryStorage(int line, IFile file, ZipEntryStorage storage) throws PartInitException, CoreException {
        ZipEntryEditorInput input = new ZipEntryEditorInput(storage);
        IEditorDescriptor desc = IDE.getEditorDescriptor((String)storage.getName());
        IEditorPart editor = SpringUIUtils.openInEditor((IEditorInput)input, (String)desc.getId());
        IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
        marker.setAttribute("lineNumber", line);
        IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
        return editor;
    }

    public static IModelElement getSelectedElement(ISelection selection, IModelElement contextElement) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Object[] objectArray = sSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object sElement = objectArray[n2];
                if (sElement instanceof Element) {
                    return BeansModelUtils.getModelElement((Element)((Element)sElement), (IModelElement)contextElement);
                }
                ++n2;
            }
        }
        return null;
    }

    public static TreePath createTreePath(IModelElement element) {
        TreePathBuilder path = new TreePathBuilder();
        while (element != null && element.getElementParent() != null) {
            path.addParent((Object)element);
            if (element instanceof IBeansConfig) {
                IBeansConfig config = (IBeansConfig)element;
                if (config.isElementArchived()) {
                    path.addParent((Object)new ZipEntryStorage((IResourceModelElement)config));
                } else {
                    path.addParent((Object)config.getElementResource());
                }
            }
            element = element.getElementParent();
        }
        return path.getPath();
    }

    public static IModelElement getContext(ITreeSelection selection) {
        TreePath path = selection.getPaths()[0];
        int i = path.getSegmentCount() - 1;
        while (i > 0) {
            Object segment = path.getSegment(i);
            if (segment instanceof IBeansConfigSet || segment instanceof IBeansConfig) {
                return (IModelElement)segment;
            }
            if (segment instanceof BeanClassReferences) {
                IBean bean = (IBean)path.getSegment(i + 1);
                return bean.getElementParent();
            }
            if (segment instanceof IFile) {
                IFile file = (IFile)segment;
                IBeansConfig config = BeansCorePlugin.getModel().getConfig(file);
                if (config != null) {
                    return config;
                }
            }
            --i;
        }
        return null;
    }

    public static boolean shouldOpenConfigFile() {
        InstanceScope context = new InstanceScope();
        IEclipsePreferences node = context.getNode("org.springframework.ide.eclipse.beans.ui");
        return node.getBoolean("org.springframework.ide.eclipse.beans.ui.shouldOpenConfigFile", true);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isBeansConfigContentType(IFile file) {
        InputStream contents;
        block16: {
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            contents = null;
            contents = file.getContents();
            IContentType contentType = contentTypeManager.findContentTypeFor(contents, file.getName());
            if (contentType == null || !contentType.isKindOf(contentTypeManager.getContentType("com.springsource.sts.config.ui.beanConfigFile"))) break block16;
            if (contents == null) return true;
            try {
                contents.close();
                return true;
            }
            catch (IOException iOException) {}
            return true;
            catch (CoreException coreException) {
                if (contents == null) return false;
                try {
                    contents.close();
                    return false;
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (IOException iOException) {
                if (contents == null) return false;
                {
                    catch (Throwable throwable) {
                        if (contents == null) throw throwable;
                        try {
                            contents.close();
                            throw throwable;
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                }
                try {
                    contents.close();
                    return false;
                }
                catch (IOException iOException3) {}
                return false;
            }
        }
        if (contents == null) return false;
        try {
            contents.close();
            return false;
        }
        catch (IOException iOException) {}
        return false;
    }
}

