/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelDecorator;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelProvider;
import org.springsource.ide.eclipse.commons.ui.ImageDescriptorRegistry;

public class BeansUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.springframework.ide.eclipse.beans.ui";
    public static final String PROJECT_EXPLORER_CONTENT_PROVIDER_ID = "org.springframework.ide.eclipse.beans.ui.navigator.projectExplorerContent";
    public static final String SPRING_EXPLORER_CONTENT_PROVIDER_ID = "org.springframework.ide.eclipse.beans.ui.navigator.springExplorerContent";
    public static final String DEFAULT_DOUBLE_CLICK_ACTION_PREFERENCE_ID = "org.springframework.ide.eclipse.beans.ui.shouldOpenConfigFile";
    public static final String SHOULD_SHOW_INFRASTRUCTURE_BEANS_PREFERENCE_ID = "org.springframework.ide.eclipse.beans.ui.shouldShowInfrastructureBeans";
    public static final String SHOULD_SHOW_INNER_BEANS_PREFERENCE_ID = "org.springframework.ide.eclipse.beans.ui.shouldShowInnerBeans";
    public static final String SHOULD_SHOW_EXTENDED_CONTENT_PREFERENCE_ID = "org.springframework.ide.eclipse.beans.ui.shouldExtendedContent";
    public static final String RESOURCE_NAME = "org.springframework.ide.eclipse.beans.ui.messages";
    private static BeansUIPlugin plugin;
    private ResourceBundle resourceBundle;
    private ImageDescriptorRegistry imageDescriptorRegistry;
    private ILabelProvider labelProvider;

    public BeansUIPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException e) {
            BeansUIPlugin.log(e);
            this.resourceBundle = null;
        }
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        BeansUIImages.initializeImageRegistry(registry);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.labelProvider != null) {
            this.labelProvider = null;
        }
        if (this.imageDescriptorRegistry != null) {
            this.imageDescriptorRegistry.dispose();
            this.imageDescriptorRegistry = null;
        }
        super.stop(context);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().setDefault(DEFAULT_DOUBLE_CLICK_ACTION_PREFERENCE_ID, true);
        this.getPreferenceStore().setDefault(SHOULD_SHOW_INFRASTRUCTURE_BEANS_PREFERENCE_ID, false);
        this.getPreferenceStore().setDefault(SHOULD_SHOW_INNER_BEANS_PREFERENCE_ID, true);
        this.getPreferenceStore().setDefault(SHOULD_SHOW_EXTENDED_CONTENT_PREFERENCE_ID, false);
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return BeansUIPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    private synchronized ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.imageDescriptorRegistry == null) {
            this.imageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.imageDescriptorRegistry;
    }

    public static ILabelProvider getLabelProvider() {
        return BeansUIPlugin.getDefault().internalGetLabelProvider();
    }

    private synchronized ILabelProvider internalGetLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new DecoratingLabelProvider((ILabelProvider)new BeansModelLabelProvider(true), (ILabelDecorator)new BeansModelLabelDecorator());
        }
        return this.labelProvider;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return BeansUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static BeansUIPlugin getDefault() {
        return plugin;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return BeansUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        return BeansUIPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        return BeansUIPlugin.getActiveWorkbenchWindow().getActivePage();
    }

    public static String getResourceString(String key) {
        String bundleString;
        ResourceBundle bundle = BeansUIPlugin.getDefault().getResourceBundle();
        if (bundle != null) {
            try {
                bundleString = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                BeansUIPlugin.log(e);
                bundleString = "!" + key + "!";
            }
        } else {
            bundleString = "!" + key + "!";
        }
        return bundleString;
    }

    public static boolean isDebug(String option) {
        String value = Platform.getDebugOption((String)option);
        return value != null && value.equalsIgnoreCase("true");
    }

    public static void log(IStatus status) {
        BeansUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(String message, Throwable exception) {
        IStatus status = BeansUIPlugin.createErrorStatus(message, exception);
        BeansUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable exception) {
        BeansUIPlugin.getDefault().getLog().log(BeansUIPlugin.createErrorStatus(BeansUIPlugin.getResourceString("Plugin.internal_error"), exception));
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, exception);
    }

    public static String getFormattedMessage(String key, Object ... args) {
        return MessageFormat.format(BeansUIPlugin.getResourceString(key), args);
    }
}

