/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.dashboard.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.springsource.ide.eclipse.commons.core.ResourceProvider;
import org.springsource.ide.eclipse.commons.core.preferences.StsProperties;
import org.springsource.ide.eclipse.dashboard.internal.ui.IdeUiPlugin;

public class MainPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int HEIGHT_MULTI_LINE_TEXT = 60;
    private List<PropertyEditor> editors;
    private Button useOldDashboardButton;
    private Button updateNewsFeed;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createUseOldDasboardButton(composite);
        this.createUpdateNewsFeedButton(composite);
        for (PropertyEditor editor : this.editors) {
            Label label = editor.createLabel(composite);
            GridDataFactory.fillDefaults().applyTo((Control)label);
            if (editor.isControlOnSeparateRow()) {
                ((GridData)label.getLayoutData()).horizontalSpan = 2;
            }
            Control control = editor.createControl(composite);
            GridDataFactory.fillDefaults().grab(true, false).applyTo(control);
            if (editor.isControlOnSeparateRow()) {
                ((GridData)control.getLayoutData()).horizontalSpan = 2;
                ((GridData)control.getLayoutData()).heightHint = 60;
            }
            editor.performReset();
        }
        return composite;
    }

    private void createUseOldDasboardButton(Composite composite) {
        this.useOldDashboardButton = new Button(composite, 32);
        this.useOldDashboardButton.setText("Use Old Dashboard");
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.useOldDashboardButton);
        this.useOldDashboardButton.setSelection(this.getUseOldDashboard());
    }

    private void createUpdateNewsFeedButton(Composite composite) {
        this.updateNewsFeed = new Button(composite, 32);
        this.updateNewsFeed.setText("News Feed Updates");
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.updateNewsFeed);
        this.updateNewsFeed.setSelection(this.getPreferenceStore().getBoolean("org.springsource.ide.eclipse.dashboard.uidashboard.news.update"));
    }

    private boolean getUseOldDashboard() {
        String value = this.getPreferenceStore().getString("org.springsource.ide.eclipse.dashboard.uidashboard.use.old");
        if (value == null) {
            return this.getDefaultUseOldDashboard();
        }
        return Boolean.valueOf(value);
    }

    private boolean getDefaultUseOldDashboard() {
        boolean useNew = StsProperties.getInstance().get("sts.new.dashboard.enabled", false);
        return !useNew;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return IdeUiPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
        this.editors = new ArrayList<PropertyEditor>();
        for (ResourceProvider.Property property : ResourceProvider.getInstance().getProperties()) {
            if (!property.isUserConfigurable()) continue;
            PropertyEditor editor = new PropertyEditor(property);
            this.editors.add(editor);
        }
    }

    protected void performDefaults() {
        this.useOldDashboardButton.setSelection(this.getPreferenceStore().getDefaultBoolean("org.springsource.ide.eclipse.dashboard.uidashboard.use.old"));
        this.updateNewsFeed.setSelection(this.getPreferenceStore().getDefaultBoolean("org.springsource.ide.eclipse.dashboard.uidashboard.news.update"));
        for (PropertyEditor editor : this.editors) {
            editor.performDefaults();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        for (PropertyEditor editor : this.editors) {
            editor.performOk();
        }
        this.setBoolean(this.getPreferenceStore(), "org.springsource.ide.eclipse.dashboard.uidashboard.use.old", this.useOldDashboardButton.getSelection());
        this.setBoolean(this.getPreferenceStore(), "org.springsource.ide.eclipse.dashboard.uidashboard.news.update", this.updateNewsFeed.getSelection());
        return super.performOk();
    }

    private void setBoolean(IPreferenceStore preferenceStore, String propName, boolean value) {
        boolean defaultValue = preferenceStore.getDefaultBoolean(propName);
        if (value == defaultValue) {
            preferenceStore.setToDefault(propName);
        } else {
            preferenceStore.setValue(propName, value);
        }
    }

    private class PropertyEditor {
        private Text control;
        private final ResourceProvider.Property property;

        public PropertyEditor(ResourceProvider.Property property) {
            this.property = property;
        }

        public Control createControl(Composite parent) {
            int style = 2048;
            if (this.property.isMultiValue()) {
                style |= 0x202;
            }
            this.control = new Text(parent, style);
            return this.control;
        }

        public Label createLabel(Composite composite) {
            Label label = new Label(composite, 0);
            if (this.property.getLabel() != null) {
                label.setText(String.valueOf(this.property.getLabel()) + ":");
            }
            return label;
        }

        public boolean isControlOnSeparateRow() {
            return this.property.isMultiValue();
        }

        public void performDefaults() {
            this.setValue(this.property.getDefaultValue());
        }

        public void performOk() {
            this.property.setValue(this.control.getText());
        }

        public void performReset() {
            this.setValue(this.property.getValue());
        }

        private void setValue(String value) {
            this.control.setText(value != null ? value : "");
        }
    }
}

