/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.dashboard.internal.ui.feeds;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.springsource.ide.eclipse.commons.core.ResourceProvider;
import org.springsource.ide.eclipse.dashboard.internal.ui.IdeUiPlugin;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.AggregateFeedJob;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.UpdateNotification;
import org.springsource.ide.eclipse.dashboard.internal.ui.feeds.IFeedListener;

public class FeedMonitor {
    public static final String RESOURCE_DASHBOARD_FEEDS_BLOGS = "dashboard.feeds.blogs";
    public static final String RESOURCE_DASHBOARD_FEEDS_UPDATE = "dashboard.feeds.update";
    private static final int FEED_POLLING_RATE = 3600000;
    private static final long FEED_STARTUP_DELAY = 15000L;
    private Date lastUpdated;
    private static FeedMonitor instance;
    private boolean newFeedItems;
    private Set<SyndEntry> feedEntries;
    private List<UpdateNotification> updates;
    private List<IFeedListener> listeners = new ArrayList<IFeedListener>();
    private AggregateFeedJob blogFeedJob = null;
    private AggregateFeedJob newsFeedJob = null;

    private FeedMonitor() {
        IPreferenceStore prefStore = IdeUiPlugin.getDefault().getPreferenceStore();
        long lastUpdateLong = prefStore.getLong("org.springsource.ide.eclipse.dashboard.uidashboard.feed.last_update");
        this.lastUpdated = new Date(lastUpdateLong);
        prefStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.springsource.ide.eclipse.dashboard.uidashboard.news.update".equals(event.getProperty())) {
                    FeedMonitor.this.initNewsFeedUpdates();
                }
            }
        });
        ResourceProvider.getInstance().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                if (FeedMonitor.RESOURCE_DASHBOARD_FEEDS_BLOGS.equals(evt.getPropertyName())) {
                    FeedMonitor.this.initBlogFeedUpdates();
                }
            }
        });
        this.addListener(new IFeedListener(){

            @Override
            public void updated(String id) {
                FeedMonitor.this.updateDashboardButtons();
            }
        });
        this.initBlogFeedUpdates();
        this.initNewsFeedUpdates();
    }

    private void initBlogFeedUpdates() {
        String[] urls;
        HashMap<String, String> springMap = new HashMap<String, String>();
        String[] stringArray = urls = ResourceProvider.getUrls((String)RESOURCE_DASHBOARD_FEEDS_BLOGS);
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            String url = stringArray[n2];
            springMap.put(url, null);
            ++n2;
        }
        if (this.blogFeedJob != null) {
            this.blogFeedJob.cancel();
        }
        if (!springMap.isEmpty()) {
            this.blogFeedJob = new AggregateFeedJob(springMap, RESOURCE_DASHBOARD_FEEDS_BLOGS);
            this.blogFeedJob.setSystem(true);
            this.blogFeedJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    Map<SyndEntry, SyndFeed> entryToFeed = FeedMonitor.this.blogFeedJob.getFeedReader().getFeedsWithEntries();
                    Set<SyndEntry> retrieveFeedEntries = entryToFeed.keySet();
                    FeedMonitor.this.newFeedItems = false;
                    FeedMonitor.this.feedEntries = new HashSet<SyndEntry>(retrieveFeedEntries);
                    FeedMonitor.this.checkFeedsUpToDate();
                    FeedMonitor.this.update(FeedMonitor.this.blogFeedJob.getFeedName());
                    if (event.getResult().getSeverity() != 8) {
                        FeedMonitor.this.blogFeedJob.schedule(3600000L);
                    }
                }
            });
            this.blogFeedJob.schedule(15000L);
        }
    }

    private void initNewsFeedUpdates() {
        if (this.newsFeedJob != null) {
            this.newsFeedJob.cancel();
        }
        if (IdeUiPlugin.getDefault().getPreferenceStore().getBoolean("org.springsource.ide.eclipse.dashboard.uidashboard.news.update")) {
            HashMap<String, String> updateMap = new HashMap<String, String>();
            updateMap.put(ResourceProvider.getUrl((String)RESOURCE_DASHBOARD_FEEDS_UPDATE), null);
            this.newsFeedJob = new AggregateFeedJob(updateMap, RESOURCE_DASHBOARD_FEEDS_UPDATE);
            this.newsFeedJob.setSystem(true);
            this.newsFeedJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    FeedMonitor.this.updates = new ArrayList<UpdateNotification>(FeedMonitor.this.newsFeedJob.getNotifications());
                    FeedMonitor.this.update(FeedMonitor.this.newsFeedJob.getFeedName());
                    if (event.getResult().getSeverity() != 8) {
                        FeedMonitor.this.newsFeedJob.schedule(3600000L);
                    }
                }
            });
            this.newsFeedJob.schedule(15000L);
        }
    }

    public static synchronized FeedMonitor getInstance() {
        if (instance == null) {
            instance = new FeedMonitor();
        }
        return instance;
    }

    public boolean isNewFeedItems() {
        return this.newFeedItems;
    }

    public Set<SyndEntry> getFeedEntries() {
        return this.feedEntries;
    }

    public List<UpdateNotification> getUpdates() {
        return this.updates;
    }

    private void update(String id) {
        if (PlatformUI.isWorkbenchRunning()) {
            for (IFeedListener listener : this.listeners) {
                listener.updated(id);
            }
        }
    }

    public void updateDashboardButtons() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ICommandService commandService;
                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWorkbenchWindow != null && (commandService = (ICommandService)activeWorkbenchWindow.getService(ICommandService.class)) != null) {
                    commandService.refreshElements("org.springsource.ide.eclipse.dashboard.ui.showDashboard", null);
                }
            }
        });
    }

    private void checkFeedsUpToDate() {
        this.newFeedItems = false;
        for (SyndEntry entry : this.feedEntries) {
            if ((entry.getUpdatedDate() == null || !entry.getUpdatedDate().after(this.lastUpdated)) && (entry.getPublishedDate() == null || !entry.getPublishedDate().after(this.lastUpdated))) continue;
            this.newFeedItems = true;
            break;
        }
    }

    public void markRead() {
        this.lastUpdated = new Date();
        IPreferenceStore prefStore = IdeUiPlugin.getDefault().getPreferenceStore();
        prefStore.setValue("org.springsource.ide.eclipse.dashboard.uidashboard.feed.last_update", this.lastUpdated.getTime());
        if (PlatformUI.isWorkbenchRunning()) {
            this.checkFeedsUpToDate();
            this.updateDashboardButtons();
        }
    }

    public void addListener(IFeedListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IFeedListener listener) {
        this.listeners.remove(listener);
    }

    public void refresh() {
        this.initBlogFeedUpdates();
        this.initNewsFeedUpdates();
    }
}

