/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.dashboard.internal.ui.editors;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.forms.widgets.BusyIndicator;
import org.eclipse.ui.internal.forms.widgets.FormHeading;
import org.eclipse.ui.internal.forms.widgets.TitleRegion;
import org.springsource.ide.eclipse.commons.ui.UiUtil;
import org.springsource.ide.eclipse.dashboard.internal.ui.IdeUiPlugin;
import org.springsource.ide.eclipse.dashboard.internal.ui.discovery.DashboardExtensionsPage;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.DashboardMainPage;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.DashboardReopener;
import org.springsource.ide.eclipse.dashboard.ui.AbstractDashboardPage;
import org.springsource.ide.eclipse.dashboard.ui.IEnabledDashboardPart;

public class MultiPageDashboardEditor
extends SharedHeaderFormEditor {
    private static final String EXTENSION_ID_DASHBOARD = "com.springsource.sts.ide.ui.dashboard";
    private static final String ELEMENT_PAGE = "page";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_LABEL = "label";
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final int LEFT_TOOLBAR_HEADER_TOOLBAR_PADDING = 3;
    private static final int VERTICAL_TOOLBAR_PADDING = 11;
    private static final String TITLE = "Spring Dashboard";
    public static String EDITOR_ID = "com.springsource.sts.internal.ide.ui.editors.MultiPageDashboardEditor";
    public static final String NEW_EDITOR_ID = "org.springsource.ide.eclipse.commons.gettingstarted.dashboard.WelcomeDashboard";
    private BusyIndicator busyLabel;
    private Label titleLabel;
    private Image headerImage;
    private DashboardMainPage mainPage;
    private IPartListener partListener;

    private static EvaluationContext createDiscoveryWizardEvaluationContext(IHandlerService handlerService) {
        EvaluationContext evaluationContext = new EvaluationContext(handlerService.getCurrentState(), Platform.class);
        evaluationContext.addVariable("platform", Platform.class);
        return evaluationContext;
    }

    private static Command getConfiguredDiscoveryWizardCommand() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command discoveryWizardCommand = service.getCommand("org.eclipse.mylyn.discovery.ui.discoveryWizardCommand");
        if (discoveryWizardCommand != null) {
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            EvaluationContext evaluationContext = MultiPageDashboardEditor.createDiscoveryWizardEvaluationContext(handlerService);
            discoveryWizardCommand.setEnabled((Object)evaluationContext);
        }
        return discoveryWizardCommand;
    }

    public MultiPageDashboardEditor() {
        DashboardReopener.ensure();
    }

    protected void addPages() {
        try {
            Command discoveryWizardCommand;
            List<PageDescriptor> pageDescriptors = this.readExtensions();
            this.mainPage = new DashboardMainPage(this);
            int index = this.addPage((IFormPage)this.mainPage);
            this.setPageText(index, "Dashboard");
            this.addPages(pageDescriptors, "tasks");
            this.addPages(pageDescriptors, "knowledgeBase");
            DashboardExtensionsPage exPage = new DashboardExtensionsPage((FormEditor)this);
            if (exPage.shouldAdd() && (discoveryWizardCommand = MultiPageDashboardEditor.getConfiguredDiscoveryWizardCommand()) != null && discoveryWizardCommand.isEnabled()) {
                index = this.addPage((IFormPage)exPage);
                this.setPageText(index, "Extensions");
            }
            this.addPages(pageDescriptors, "additions");
            this.getToolkit().decorateFormHeading(this.getHeaderForm().getForm().getForm());
        }
        catch (PartInitException e) {
            IdeUiPlugin.log(e);
        }
    }

    private List<AbstractDashboardPage> addPages(List<PageDescriptor> descriptors, String path) {
        final ArrayList<AbstractDashboardPage> pages = new ArrayList<AbstractDashboardPage>();
        final Iterator<PageDescriptor> it = descriptors.iterator();
        while (it.hasNext()) {
            final PageDescriptor descriptor = it.next();
            if (path != null && !path.equals(descriptor.getPath())) continue;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Error creating dashboard page: \"" + descriptor.getId() + "\"", e));
                }

                public void run() throws Exception {
                    AbstractDashboardPage page = descriptor.createPage();
                    if (page != null) {
                        page.initialize((FormEditor)MultiPageDashboardEditor.this);
                        if (page instanceof IEnabledDashboardPart && !((IEnabledDashboardPart)((Object)page)).shouldAdd()) {
                            return;
                        }
                        int index = MultiPageDashboardEditor.this.addPage((IFormPage)page);
                        MultiPageDashboardEditor.this.setPageText(index, descriptor.getLabel());
                        pages.add(page);
                    }
                    it.remove();
                }
            });
        }
        return pages;
    }

    public void close(boolean save) {
        this.mainPage.cancelUnfinishedJobs();
        super.close(save);
    }

    protected Composite createPageContainer(Composite parent) {
        Composite composite;
        block2: {
            composite = super.createPageContainer(parent);
            EditorUtil.initializeScrollbars((ScrolledForm)this.getHeaderForm().getForm());
            try {
                FormHeading heading = (FormHeading)this.getHeaderForm().getForm().getForm().getHead();
                Field field = FormHeading.class.getDeclaredField("titleRegion");
                field.setAccessible(true);
                TitleRegion titleRegion = (TitleRegion)field.get(heading);
                this.titleLabel = new Label((Composite)titleRegion, 0);
                this.titleLabel.setForeground(heading.getForeground());
                this.titleLabel.setFont(heading.getFont());
                this.titleLabel.setText("Spring Tool Suite");
                this.titleLabel.setVisible(true);
                this.getBusyLabel();
                titleRegion.addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent e) {
                        MultiPageDashboardEditor.this.updateSizeAndLocations();
                    }
                });
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to obtain busy label toolbar", (Throwable)e));
                if (this.titleLabel == null) break block2;
                this.titleLabel.dispose();
                this.titleLabel = null;
            }
        }
        this.updateHeaderLabel();
        return composite;
    }

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(UiUtil.getFormColors((Display)display));
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    private BusyIndicator getBusyLabel() {
        block7: {
            if (this.busyLabel != null) {
                return this.busyLabel;
            }
            try {
                FormHeading heading = (FormHeading)this.getHeaderForm().getForm().getForm().getHead();
                heading.setBusy(true);
                heading.setBusy(false);
                Field field = FormHeading.class.getDeclaredField("titleRegion");
                field.setAccessible(true);
                TitleRegion titleRegion = (TitleRegion)field.get(heading);
                Control[] controlArray = titleRegion.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    if (child instanceof BusyIndicator) {
                        this.busyLabel = (BusyIndicator)child;
                    }
                    ++n2;
                }
                if (this.busyLabel != null) break block7;
                return null;
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Failed to obtain busy label toolbar", (Throwable)e));
                this.busyLabel = null;
                return this.busyLabel;
            }
        }
        this.busyLabel.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                MultiPageDashboardEditor.this.updateSizeAndLocations();
            }
        });
        this.busyLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MultiPageDashboardEditor.this.busyLabel.setMenu(null);
                MultiPageDashboardEditor.this.busyLabel = null;
            }
        });
        if (this.titleLabel != null) {
            this.titleLabel.moveAbove((Control)this.busyLabel);
        }
        this.updateSizeAndLocations();
        return this.busyLabel;
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(editorInput);
        this.partListener = new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (MultiPageDashboardEditor.this == part) {
                    IPreferenceStore prefs = IdeUiPlugin.getDefault().getPreferenceStore();
                    prefs.setValue("org.springsource.ide.eclipse.dashboard.uidashboard.startup", false);
                    MultiPageDashboardEditor.this.disposeListeners();
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
            }
        };
        site.getPage().addPartListener(this.partListener);
    }

    private void disposeListeners() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null && this.partListener != null) {
            page.removePartListener(this.partListener);
        }
        this.partListener = null;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private List<PageDescriptor> readExtensions() {
        IExtension[] extensions;
        ArrayList<PageDescriptor> pageDescriptors = new ArrayList<PageDescriptor>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_DASHBOARD);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(ELEMENT_PAGE)) {
                    pageDescriptors.add(new ExtensionPageDescriptor(element));
                }
                ++n4;
            }
            ++n2;
        }
        return pageDescriptors;
    }

    private void setHeaderImage(final Image image) {
        BusyIndicator busyLabel = this.getBusyLabel();
        if (busyLabel == null) {
            return;
        }
        final Point size = busyLabel.getSize();
        Point titleSize = this.titleLabel.computeSize(-1, -1, true);
        size.x += titleSize.x + 3;
        size.y = Math.max(titleSize.y, size.y) + 11;
        final int padding = size.x > 0 ? 10 : 1;
        final Rectangle imageBounds = image != null ? image.getBounds() : new Rectangle(0, 0, 0, 0);
        int tempHeight = image != null ? Math.max(size.y + 1, imageBounds.height) : size.y + 1;
        final int height = tempHeight > imageBounds.height + 5 ? tempHeight - 5 : tempHeight;
        CompositeImageDescriptor descriptor = new CompositeImageDescriptor(){

            protected void drawCompositeImage(int width, int height2) {
                if (image != null) {
                    this.drawImage(image.getImageData(), size.x + padding, (height2 - image.getBounds().height) / 2);
                }
            }

            protected Point getSize() {
                return new Point(size.x + padding + imageBounds.width, height);
            }
        };
        Image newHeaderImage = descriptor.createImage();
        busyLabel.setImage(newHeaderImage);
        if (this.headerImage != null) {
            this.headerImage.dispose();
        }
        this.headerImage = newHeaderImage;
        this.getHeaderForm().getForm().reflow(true);
    }

    private void updateHeaderLabel() {
        if (this.titleLabel != null) {
            this.titleLabel.setText(TITLE);
            this.getHeaderForm().getForm().setText(null);
            this.setHeaderImage(null);
        } else {
            this.getHeaderForm().getForm().setText(TITLE);
        }
    }

    private void updateSizeAndLocations() {
        if (this.titleLabel != null && !this.titleLabel.isDisposed()) {
            Point size = this.titleLabel.computeSize(-1, -1, true);
            this.titleLabel.setBounds(this.busyLabel.getLocation().x + 3, this.busyLabel.getLocation().y + 11, size.x + 200, size.y + 200);
        }
    }

    private static class ExtensionPageDescriptor
    extends PageDescriptor {
        private final IConfigurationElement element;

        public ExtensionPageDescriptor(IConfigurationElement element) {
            super(element.getAttribute(MultiPageDashboardEditor.ATTRIBUTE_ID));
            this.element = element;
            this.setLabel(element.getAttribute(MultiPageDashboardEditor.ATTRIBUTE_LABEL));
            this.setPath(element.getAttribute(MultiPageDashboardEditor.ATTRIBUTE_PATH));
        }

        @Override
        public AbstractDashboardPage createPage() {
            Object object;
            block3: {
                try {
                    object = WorkbenchPlugin.createExtension((IConfigurationElement)this.element, (String)MultiPageDashboardEditor.ATTRIBUTE_CLASS);
                    if (object instanceof AbstractDashboardPage) break block3;
                    StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Could not load " + object.getClass().getCanonicalName() + " must implement " + AbstractDashboardPage.class.getCanonicalName()));
                    return null;
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Could not read dashboard extension", (Throwable)e));
                    return null;
                }
            }
            return (AbstractDashboardPage)((Object)object);
        }
    }

    private static abstract class PageDescriptor {
        private final String id;
        private String path;
        private String label;

        public PageDescriptor(String id) {
            Assert.isNotNull((Object)id);
            this.id = id;
        }

        public abstract AbstractDashboardPage createPage();

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            PageDescriptor other = (PageDescriptor)obj;
            return this.id.equals(other.id);
        }

        public final String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public final String getPath() {
            return this.path;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id.hashCode();
            return result;
        }

        public final PageDescriptor setLabel(String label) {
            this.label = label;
            return this;
        }

        public final PageDescriptor setPath(String path) {
            this.path = path;
            return this;
        }
    }
}

