/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.workspace;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.springsource.ide.eclipse.commons.frameworks.core.FrameworkCoreActivator;
import org.springsource.ide.eclipse.commons.livexp.ui.Disposable;

public class ClasspathListenerManager
implements Disposable {
    private ClasspathListener listener;
    private MyListener myListener;

    public ClasspathListenerManager(ClasspathListener listener, boolean initialEvent) {
        this.listener = listener;
        if (initialEvent) {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                try {
                    if (p.isAccessible() && p.hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject jp = JavaCore.create((IProject)p);
                        listener.classpathChanged(jp);
                    }
                }
                catch (CoreException e) {
                    FrameworkCoreActivator.log(e);
                }
                ++n2;
            }
        }
        this.myListener = new MyListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.myListener, (int)1);
    }

    public ClasspathListenerManager(ClasspathListener listener) {
        this(listener, false);
    }

    public void dispose() {
        if (this.myListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.myListener);
            this.myListener = null;
        }
    }

    public static interface ClasspathListener {
        public void classpathChanged(IJavaProject var1);
    }

    private class MyListener
    implements IElementChangedListener {
        private MyListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            this.visit(event.getDelta());
        }

        private void visit(IJavaElementDelta delta) {
            IJavaElement el = delta.getElement();
            switch (el.getElementType()) {
                case 1: {
                    this.visitChildren(delta);
                    break;
                }
                case 2: {
                    if (!this.isClasspathChanged(delta.getFlags())) break;
                    ClasspathListenerManager.this.listener.classpathChanged((IJavaProject)el);
                    break;
                }
            }
        }

        private boolean isClasspathChanged(int flags) {
            return (flags & 0x220000) != 0;
        }

        public void visitChildren(IJavaElementDelta delta) {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta c = iJavaElementDeltaArray[n2];
                this.visit(c);
                ++n2;
            }
        }
    }
}

