/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.util;

import java.io.File;
import java.io.IOException;
import org.springsource.ide.eclipse.commons.livexp.util.Log;

public class FileUtil {
    public static File createTempDirectoryWithTimestamp(String name) throws IOException {
        return FileUtil.createTempDirectory(name, Long.toString(System.nanoTime()));
    }

    public static File createTempDirectory(String name) throws IOException {
        return FileUtil.createTempDirectory(name, null);
    }

    public static File createTempDirectory(String name, String suffix) throws IOException {
        File tempFolder = File.createTempFile(name, suffix);
        if (!tempFolder.delete()) {
            throw new IOException("Could not delete temp file: " + tempFolder.getAbsolutePath());
        }
        if (!tempFolder.mkdirs()) {
            throw new IOException("Could not create temp directory: " + tempFolder.getAbsolutePath());
        }
        FileUtil.deleteOnShutdown(tempFolder);
        return tempFolder;
    }

    public static File createTempDirectory() throws IOException {
        return FileUtil.createTempDirectoryWithTimestamp("temp");
    }

    public static boolean isJarFile(File jarFile) {
        try {
            return jarFile != null && jarFile.isFile() && jarFile.toString().toLowerCase().endsWith(".jar");
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
            return false;
        }
    }

    private static void deleteOnShutdown(File tempFolder) {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> FileUtil.deleteResource(tempFolder)));
        }
        catch (IllegalArgumentException | IllegalStateException | SecurityException e) {
            Log.log((Throwable)e);
        }
    }

    private static void deleteResource(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File content = fileArray[n2];
                FileUtil.deleteResource(content);
                ++n2;
            }
        }
        file.delete();
    }
}

