/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.internal.cache;

import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.cache.Cache;

public class LimitedTimeCache<K, V>
implements Cache<K, V> {
    private static final boolean DEBUG = false;
    public final long MAX_AGE;
    public final long AGE_MARGIN;
    private Map<K, Entry> cache = new HashMap<K, Entry>();
    private Job clearExpiredJob = new Job("Clean expired cache entries"){
        {
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            long oldest = LimitedTimeCache.this.clearExpired();
            if (oldest >= 0L) {
                LimitedTimeCache.this.clearExpiredJob.schedule(LimitedTimeCache.this.MAX_AGE - oldest + LimitedTimeCache.this.AGE_MARGIN);
            }
            return Status.OK_STATUS;
        }
    };

    private static void debug(String string) {
    }

    public LimitedTimeCache(Duration MAX_AGE_DURATION) {
        this.MAX_AGE = MAX_AGE_DURATION.toMillis();
        this.AGE_MARGIN = Math.max(1000L, this.MAX_AGE / 20L);
    }

    @Override
    public synchronized V get(K key) {
        Entry e = this.cache.get(key);
        if (e != null) {
            e.lastUsed = System.currentTimeMillis();
            return e.value;
        }
        return null;
    }

    @Override
    public synchronized void put(K key, V value) {
        boolean wasEmpty = this.cache.isEmpty();
        if (value == null) {
            this.cache.remove(key);
        } else {
            this.cache.put(key, new Entry(value));
        }
        if (wasEmpty && !this.cache.isEmpty()) {
            this.clearExpiredJob.schedule(this.MAX_AGE + this.AGE_MARGIN);
        }
    }

    @Override
    public synchronized void clear() {
        this.cache.clear();
    }

    private synchronized long clearExpired() {
        LimitedTimeCache.debug(">>> clearExpired MAX_AGE = " + this.MAX_AGE);
        Iterator<Map.Entry<K, Entry>> iter = this.cache.entrySet().iterator();
        long oldest = -1L;
        while (iter.hasNext()) {
            Map.Entry<K, Entry> me = iter.next();
            Entry e = me.getValue();
            long age = e.age();
            if (age >= this.MAX_AGE) {
                LimitedTimeCache.debug("Expired: " + me.getKey() + " age: " + e.age());
                iter.remove();
                continue;
            }
            oldest = Math.max(oldest, age);
        }
        LimitedTimeCache.debug("<<< clearExpired [" + this.cache.size() + "]");
        return oldest;
    }

    public static <K, V> Function<K, V> applyOn(Duration duration, Function<K, V> func) {
        LimitedTimeCache cache = new LimitedTimeCache(duration);
        return k -> {
            Object v = cache.get(k);
            if (v == null) {
                v = func.apply(k);
                cache.put(k, v);
            }
            return v;
        };
    }

    private class Entry {
        long lastUsed;
        V value;

        Entry(V v) {
            this.value = v;
            this.lastUsed = System.currentTimeMillis();
        }

        long age() {
            return System.currentTimeMillis() - this.lastUsed;
        }
    }
}

