/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadManager;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.URLConnectionFactory;
import org.springsource.ide.eclipse.commons.frameworks.core.util.IOUtil;

public class SimpleDownloadService
implements DownloadManager.DownloadService {
    private final URLConnectionFactory connectionFactory;
    private static final boolean DEBUG = false;

    public SimpleDownloadService() {
        this(new URLConnectionFactory());
    }

    public SimpleDownloadService(URLConnectionFactory urlConnectionFactory) {
        this.connectionFactory = urlConnectionFactory;
    }

    @Override
    public void fetch(URL url, OutputStream writeTo) throws IOException {
        URLConnection conn = null;
        InputStream input = null;
        try {
            conn = this.connectionFactory.createConnection(url);
            conn.connect();
            input = conn.getInputStream();
            IOUtil.pipe(input, writeTo);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

