/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.plugins;

import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

public class ProgressIndicatorWithStop {
    private ProgressIndicator refreshProgressIndicator;
    private ToolBar toolBar;
    private Label refreshLabel;
    private String progressMessage;
    private boolean isCancellable = true;

    public ProgressIndicatorWithStop(String progressLabel, Composite parent, boolean isCancellable) {
        this.progressMessage = progressLabel;
        this.isCancellable = isCancellable;
        this.createStatusArea(parent);
    }

    protected void createStatusArea(Composite parent) {
        if (parent == null) {
            return;
        }
        Composite statusArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(statusArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)statusArea);
        this.refreshLabel = new Label(statusArea, 0x1000000);
        GridDataFactory.fillDefaults().grab(false, false).align(16384, 0x1000000).applyTo((Control)this.refreshLabel);
        this.refreshLabel.setText(this.progressMessage != null ? this.progressMessage : "");
        this.refreshProgressIndicator = new ProgressIndicator(statusArea);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).applyTo((Control)this.refreshProgressIndicator);
        this.toolBar = new ToolBar(statusArea, 0x880000);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).applyTo((Control)this.toolBar);
        if (this.isCancellable) {
            ToolItem item = new ToolItem(this.toolBar, 0);
            item.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_STOP"));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProgressIndicatorWithStop.this.stop();
                }
            });
        }
        this.setControlVisibility(false);
    }

    public void start() {
        if (!this.refreshProgressIndicator.isDisposed() && !this.refreshProgressIndicator.isVisible()) {
            this.refreshProgressIndicator.beginAnimatedTask();
            this.setControlVisibility(true);
        }
    }

    protected void setControlVisibility(boolean visibility) {
        if (!this.refreshLabel.isDisposed()) {
            this.refreshLabel.setVisible(visibility);
        }
        if (!this.toolBar.isDisposed()) {
            this.toolBar.setVisible(visibility);
        }
        if (!this.refreshProgressIndicator.isDisposed()) {
            this.refreshProgressIndicator.setVisible(visibility);
        }
    }

    public void finish() {
        if (!this.refreshProgressIndicator.isDisposed() && this.refreshProgressIndicator.isVisible()) {
            this.refreshProgressIndicator.done();
            this.setControlVisibility(false);
        }
    }

    public void stop() {
        this.finish();
    }
}

