/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameter;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.AbstractParameterEditor;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.IParameterEditor;

public class BooleanParameterEditor
extends AbstractParameterEditor
implements IParameterEditor {
    private Button boolButton;

    public BooleanParameterEditor(ICommandParameter command) {
        super(command, false);
    }

    @Override
    public Composite createControls(Composite parent) {
        Composite baseCommandArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).applyTo(baseCommandArea);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)baseCommandArea);
        ICommandParameterDescriptor parameter = this.getParameterDescriptor();
        String parameterName = parameter.getName();
        Object defaultValue = this.getParameter().getValue();
        boolean valueToSet = defaultValue instanceof Boolean ? (Boolean)defaultValue : false;
        this.boolButton = new Button(baseCommandArea, 32);
        this.boolButton.setText(parameterName);
        this.boolButton.setData((Object)parameterName);
        this.boolButton.setSelection(valueToSet);
        this.boolButton.setToolTipText(parameter.getDescription());
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.boolButton);
        this.boolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BooleanParameterEditor.this.setParameterValueAndNotifyClear(new Boolean(BooleanParameterEditor.this.boolButton.getSelection()));
            }
        });
        return baseCommandArea;
    }

    @Override
    protected void clearControls() {
        if (this.boolButton != null && !this.boolButton.isDisposed()) {
            this.boolButton.setSelection(false);
        }
    }

    public Button getButtonControl() {
        return this.boolButton;
    }
}

