/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.beans.ui.graph.BeansGraphPlugin;

public class BeansGraphImages {
    private static final String ICON_PATH_PREFIX = "icons/full/";
    private static final String NAME_PREFIX = "org.springframework.ide.eclipse.beans.ui.graph.";
    private static final int NAME_PREFIX_LENGTH = "org.springframework.ide.eclipse.beans.ui.graph.".length();
    private static URL ICON_BASE_URL = null;
    private static Map imageDescriptors;
    private static ImageRegistry imageRegistry;
    public static final String IMG_OBJS_EXPORT_ENABLED = "org.springframework.ide.eclipse.beans.ui.graph.export_wiz_obj.gif";
    public static final String IMG_OBJS_EXPORT_DISABLED = "org.springframework.ide.eclipse.beans.ui.graph.export_wiz.gif";
    public static final String IMG_OBJS_BEANS_GRAPH = "org.springframework.ide.eclipse.beans.ui.graph.beans_graph_obj.gif";
    private static final String OBJECT = "obj16/";
    public static final ImageDescriptor DESC_OBJS_EXPORT_ENABLED;
    public static final ImageDescriptor DESC_OBJS_EXPORT_DISABLED;
    public static final ImageDescriptor DESC_OBJS_BEANS_GPRAH;

    static {
        try {
            ICON_BASE_URL = new URL(BeansGraphPlugin.getDefault().getBundle().getEntry("/"), ICON_PATH_PREFIX);
        }
        catch (MalformedURLException e) {
            BeansGraphPlugin.log(e);
        }
        DESC_OBJS_EXPORT_ENABLED = BeansGraphImages.createManaged(OBJECT, IMG_OBJS_EXPORT_ENABLED);
        DESC_OBJS_EXPORT_DISABLED = BeansGraphImages.createManaged(OBJECT, IMG_OBJS_EXPORT_DISABLED);
        DESC_OBJS_BEANS_GPRAH = BeansGraphImages.createManaged(OBJECT, IMG_OBJS_BEANS_GRAPH);
    }

    public static Image getImage(String key) {
        return BeansGraphImages.getImageRegistry().get(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        BeansGraphImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        BeansGraphImages.setImageDescriptors(action, "lcl16", iconName);
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
            for (String key : imageDescriptors.keySet()) {
                imageRegistry.put(key, (ImageDescriptor)imageDescriptors.get(key));
            }
            imageDescriptors = null;
        }
        return imageRegistry;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)BeansGraphImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            BeansGraphPlugin.log(e);
        }
        action.setImageDescriptor(BeansGraphImages.create("e" + type, relPath));
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)BeansGraphImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (imageDescriptors == null) {
                imageDescriptors = new HashMap();
            }
            imageDescriptors.put(name, result);
            if (imageRegistry != null) {
                BeansGraphPlugin.log("Image registry already defined", null);
            }
            return result;
        }
        catch (MalformedURLException e) {
            BeansGraphPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)BeansGraphImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            BeansGraphPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(ICON_BASE_URL, buffer.toString());
    }
}

