/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.util.ws;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.Proxy;
import java.util.Map;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.sonarsource.sonarlint.core.util.ws.DeleteRequest;
import org.sonarsource.sonarlint.core.util.ws.GetRequest;
import org.sonarsource.sonarlint.core.util.ws.OkHttpClientBuilder;
import org.sonarsource.sonarlint.core.util.ws.OkHttpResponse;
import org.sonarsource.sonarlint.core.util.ws.PostRequest;
import org.sonarsource.sonarlint.core.util.ws.WsConnector;
import org.sonarsource.sonarlint.core.util.ws.WsRequest;
import org.sonarsource.sonarlint.core.util.ws.WsResponse;

public class HttpConnector
implements WsConnector {
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLISECONDS = 30000;
    public static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 60000;
    private final HttpUrl baseUrl;
    private final String credentials;
    private final OkHttpClient okHttpClient;

    private HttpConnector(Builder builder) {
        this.baseUrl = HttpUrl.parse(builder.url.endsWith("/") ? builder.url : String.format("%s/", builder.url));
        Preconditions.checkArgument(this.baseUrl != null, "Malformed URL: '%s'", builder.url);
        OkHttpClientBuilder okHttpClientBuilder = new OkHttpClientBuilder();
        okHttpClientBuilder.setUserAgent(builder.userAgent);
        this.credentials = Strings.isNullOrEmpty(builder.login) ? null : Credentials.basic(builder.login, Strings.nullToEmpty(builder.password));
        okHttpClientBuilder.setProxy(builder.proxy);
        okHttpClientBuilder.setProxyLogin(builder.proxyLogin);
        okHttpClientBuilder.setProxyPassword(builder.proxyPassword);
        okHttpClientBuilder.setConnectTimeoutMs(builder.connectTimeoutMs);
        okHttpClientBuilder.setReadTimeoutMs(builder.readTimeoutMs);
        okHttpClientBuilder.setSSLSocketFactory(builder.sslSocketFactory);
        okHttpClientBuilder.setTrustManager(builder.sslTrustManager);
        this.okHttpClient = okHttpClientBuilder.build();
    }

    @Override
    public String baseUrl() {
        return this.baseUrl.url().toExternalForm();
    }

    public OkHttpClient okHttpClient() {
        return this.okHttpClient;
    }

    @Override
    public WsResponse call(WsRequest httpRequest) {
        if (httpRequest instanceof GetRequest) {
            return this.get((GetRequest)httpRequest);
        }
        if (httpRequest instanceof PostRequest) {
            return this.post((PostRequest)httpRequest);
        }
        throw new IllegalArgumentException(String.format("Unsupported implementation: %s", httpRequest.getClass()));
    }

    private WsResponse get(GetRequest getRequest) {
        HttpUrl.Builder urlBuilder = this.prepareUrlBuilder(getRequest);
        Request.Builder okRequestBuilder = this.prepareOkRequestBuilder(getRequest, urlBuilder).get();
        return this.doCall(okRequestBuilder.build());
    }

    private WsResponse post(PostRequest postRequest) {
        HttpUrl.Builder urlBuilder = this.prepareUrlBuilder(postRequest);
        Request.Builder okRequestBuilder = this.prepareOkRequestBuilder(postRequest, urlBuilder);
        Map<String, PostRequest.Part> parts = postRequest.getParts();
        if (parts.isEmpty()) {
            okRequestBuilder.post(RequestBody.create(null, ""));
        } else {
            MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
            bodyBuilder.setType(MultipartBody.FORM);
            for (Map.Entry<String, PostRequest.Part> param : parts.entrySet()) {
                PostRequest.Part part = param.getValue();
                bodyBuilder.addPart(Headers.of("Content-Disposition", String.format("form-data; name=\"%s\"", param.getKey())), RequestBody.create(MediaType.parse(part.getMediaType()), part.getFile()));
            }
            okRequestBuilder.post(bodyBuilder.build());
        }
        return this.doCall(okRequestBuilder.build());
    }

    public WsResponse post(PostRequest postRequest, String body) {
        HttpUrl.Builder urlBuilder = this.prepareUrlBuilder(postRequest);
        Request.Builder okRequestBuilder = this.prepareOkRequestBuilder(postRequest, urlBuilder);
        okRequestBuilder.post(RequestBody.create(MediaType.parse(postRequest.getMediaType()), body));
        return this.doCall(okRequestBuilder.build());
    }

    public WsResponse delete(DeleteRequest deleteRequest, String body) {
        HttpUrl.Builder urlBuilder = this.prepareUrlBuilder(deleteRequest);
        Request.Builder okRequestBuilder = this.prepareOkRequestBuilder(deleteRequest, urlBuilder);
        okRequestBuilder.delete(RequestBody.create(MediaType.parse(deleteRequest.getMediaType()), body));
        return this.doCall(okRequestBuilder.build());
    }

    private HttpUrl.Builder prepareUrlBuilder(WsRequest wsRequest) {
        String path = wsRequest.getPath();
        HttpUrl.Builder urlBuilder = this.baseUrl.resolve(path.startsWith("/") ? path.replaceAll("^(/)+", "") : path).newBuilder();
        wsRequest.getParameters().getKeys().forEach(key -> wsRequest.getParameters().getValues((String)key).forEach(value -> urlBuilder.addQueryParameter((String)key, (String)value)));
        return urlBuilder;
    }

    private Request.Builder prepareOkRequestBuilder(WsRequest getRequest, HttpUrl.Builder urlBuilder) {
        Request.Builder okHttpRequestBuilder = new Request.Builder().url(urlBuilder.build()).addHeader("Accept", getRequest.getMediaType()).addHeader("Accept-Charset", "UTF-8");
        if (this.credentials != null) {
            okHttpRequestBuilder.header("Authorization", this.credentials);
        }
        return okHttpRequestBuilder;
    }

    private OkHttpResponse doCall(Request okRequest) {
        Call call = this.okHttpClient.newCall(okRequest);
        try {
            Response okResponse = call.execute();
            return new OkHttpResponse(okResponse);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to request " + okRequest.url(), e);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String url;
        private String userAgent;
        private String login;
        private String password;
        private Proxy proxy;
        private String proxyLogin;
        private String proxyPassword;
        private int connectTimeoutMs = 30000;
        private int readTimeoutMs = 60000;
        private SSLSocketFactory sslSocketFactory = null;
        private X509TrustManager sslTrustManager = null;

        private Builder() {
        }

        public Builder userAgent(@Nullable String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder credentials(@Nullable String login, @Nullable String password) {
            this.login = login;
            this.password = password;
            return this;
        }

        public Builder token(@Nullable String token) {
            this.login = token;
            this.password = null;
            return this;
        }

        public Builder connectTimeoutMilliseconds(int i) {
            this.connectTimeoutMs = i;
            return this;
        }

        public Builder setSSLSocketFactory(@Nullable SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public Builder setTrustManager(@Nullable X509TrustManager sslTrustManager) {
            this.sslTrustManager = sslTrustManager;
            return this;
        }

        public Builder readTimeoutMilliseconds(int i) {
            this.readTimeoutMs = i;
            return this;
        }

        public Builder proxy(@Nullable Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyCredentials(@Nullable String proxyLogin, @Nullable String proxyPassword) {
            this.proxyLogin = proxyLogin;
            this.proxyPassword = proxyPassword;
            return this;
        }

        public HttpConnector build() {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(this.url), "Server URL is not defined");
            return new HttpConnector(this);
        }
    }
}

