/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.util.ws;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.util.ws.Parameters;
import org.sonarsource.sonarlint.core.util.ws.WsRequest;

abstract class BaseRequest<SELF extends BaseRequest>
implements WsRequest {
    private final String path;
    private String mediaType = "application/json";
    private final DefaultParameters parameters = new DefaultParameters();

    BaseRequest(String path) {
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    public SELF setMediaType(String s) {
        Objects.requireNonNull(s, "media type of response cannot be null");
        this.mediaType = s;
        return (SELF)this;
    }

    public SELF setParam(String key, @Nullable String value) {
        return this.setSingleValueParam(key, value);
    }

    public SELF setParam(String key, @Nullable Integer value) {
        return this.setSingleValueParam(key, value);
    }

    public SELF setParam(String key, @Nullable Long value) {
        return this.setSingleValueParam(key, value);
    }

    public SELF setParam(String key, @Nullable Float value) {
        return this.setSingleValueParam(key, value);
    }

    public SELF setParam(String key, @Nullable Boolean value) {
        return this.setSingleValueParam(key, value);
    }

    private SELF setSingleValueParam(String key, @Nullable Object value) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "a WS parameter key cannot be null");
        if (value == null) {
            return (SELF)this;
        }
        this.parameters.setValue(key, value.toString());
        return (SELF)this;
    }

    public SELF setParam(String key, @Nullable Collection<? extends Object> values) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "a WS parameter key cannot be null");
        if (values == null || values.isEmpty()) {
            return (SELF)this;
        }
        this.parameters.setValues(key, values.stream().filter(Objects::nonNull).map(Object::toString).filter(value -> !value.isEmpty()).collect(Collectors.toList()));
        return (SELF)this;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    private static class DefaultParameters
    implements Parameters {
        private final ListMultimap<String, String> keyValues = LinkedListMultimap.create();

        private DefaultParameters() {
        }

        @Override
        @CheckForNull
        public String getValue(String key) {
            return this.keyValues.containsKey(key) ? this.keyValues.get(key).get(0) : null;
        }

        @Override
        public List<String> getValues(String key) {
            return this.keyValues.get(key);
        }

        @Override
        public Set<String> getKeys() {
            return this.keyValues.keySet();
        }

        private DefaultParameters setValue(String key, String value) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(key));
            Preconditions.checkArgument(value != null);
            this.keyValues.putAll(key, Collections.singletonList(value));
            return this;
        }

        private DefaultParameters setValues(String key, Collection<String> values) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(key));
            Preconditions.checkArgument(values != null && !values.isEmpty());
            this.keyValues.putAll(key, values.stream().map(Object::toString).filter(Objects::nonNull).collect(Collectors.toList()));
            return this;
        }
    }
}

