/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.util;

import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.client.api.common.ProgressMonitor;
import org.sonarsource.sonarlint.core.client.api.exceptions.CanceledException;

public class ProgressWrapper {
    private final ProgressMonitor handler;
    private final float offset;
    private final float factor;
    private final String msgPrefix;

    private ProgressWrapper(float offset, float factor, @Nullable String msgPrefix, @Nullable ProgressMonitor handler) {
        this.offset = offset;
        this.factor = factor;
        this.msgPrefix = msgPrefix;
        this.handler = handler == null ? new NoOpProgressMonitor() : handler;
    }

    public ProgressWrapper(@Nullable ProgressMonitor handler) {
        this(0.0f, 1.0f, null, handler);
    }

    public ProgressWrapper subProgress(float fromFraction, float toFraction, String msgPrefix) {
        return new ProgressWrapper(this.offset + fromFraction * this.factor, (toFraction - fromFraction) * this.factor, this.prependPrefix(msgPrefix), this.handler);
    }

    public void checkCancel() {
        if (this.handler.isCanceled()) {
            this.handler.setMessage("Cancelling");
            throw new CanceledException();
        }
    }

    public boolean isCanceled() {
        return this.handler.isCanceled();
    }

    public void setProgress(String msg, float fraction) {
        this.handler.setMessage(this.prependPrefix(msg));
        this.setFraction(fraction);
    }

    private String prependPrefix(String suffix) {
        return this.msgPrefix != null ? this.msgPrefix + " - " + suffix : suffix;
    }

    public void setProgressAndCheckCancel(String msg, float fraction) {
        this.checkCancel();
        this.setProgress(msg, fraction);
    }

    private void setFraction(float fraction) {
        this.handler.setFraction(this.offset + fraction * this.factor);
    }

    public void finishNonCancelableSection() {
        this.handler.finishNonCancelableSection();
    }

    public void startNonCancelableSection() {
        this.handler.startNonCancelableSection();
    }

    private static class NoOpProgressMonitor
    extends ProgressMonitor {
        private NoOpProgressMonitor() {
        }
    }
}

