/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.tracking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.sonarsource.sonarlint.core.tracking.Trackable;
import org.sonarsource.sonarlint.core.tracking.TrackableSupplier;
import org.sonarsource.sonarlint.core.tracking.Tracking;

public class Tracker<R extends Trackable, B extends Trackable> {
    public Tracking<R, B> track(TrackableSupplier<R> rawTrackableSupplier, TrackableSupplier<B> baseTrackableSupplier) {
        Tracking<R, B> tracking = new Tracking<R, B>(rawTrackableSupplier, baseTrackableSupplier);
        this.match(tracking, LineAndTextRangeHashKeyFactory.INSTANCE);
        this.match(tracking, TextRangeHashAndMessageKeyFactory.INSTANCE);
        this.match(tracking, LineAndMessageKeyFactory.INSTANCE);
        this.match(tracking, TextRangeHashKeyFactory.INSTANCE);
        this.match(tracking, LineAndLineHashKeyFactory.INSTANCE);
        this.match(tracking, LineHashKeyFactory.INSTANCE);
        this.match(tracking, ServerIssueSearchKeyFactory.INSTANCE);
        return tracking;
    }

    private void match(Tracking<R, B> tracking, SearchKeyFactory factory) {
        if (tracking.isComplete()) {
            return;
        }
        HashMap baseSearch = new HashMap();
        for (Trackable base : tracking.getUnmatchedBases()) {
            SearchKey searchKey = factory.apply(base);
            if (!baseSearch.containsKey(searchKey)) {
                baseSearch.put(searchKey, new ArrayList());
            }
            ((List)baseSearch.get(searchKey)).add(base);
        }
        for (Trackable raw : tracking.getUnmatchedRaws()) {
            SearchKey rawKey = factory.apply(raw);
            Collection bases = (Collection)baseSearch.get(rawKey);
            if (bases == null || bases.isEmpty()) continue;
            Trackable match = (Trackable)bases.iterator().next();
            tracking.match(raw, match);
            ((List)baseSearch.get(rawKey)).remove(match);
        }
    }

    private static enum ServerIssueSearchKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey apply(Trackable trackable) {
            return new ServerIssueSearchKey(trackable);
        }
    }

    private static class ServerIssueSearchKey
    implements SearchKey {
        private final String serverIssueKey;

        ServerIssueSearchKey(Trackable trackable) {
            this.serverIssueKey = trackable.getServerIssueKey();
        }

        public boolean equals(Object o) {
            ServerIssueSearchKey that = (ServerIssueSearchKey)o;
            return !ServerIssueSearchKey.isBlank(this.serverIssueKey) && !ServerIssueSearchKey.isBlank(that.serverIssueKey) && this.serverIssueKey.equals(that.serverIssueKey);
        }

        private static boolean isBlank(String s) {
            return s == null || s.isEmpty();
        }

        public int hashCode() {
            return this.serverIssueKey != null ? this.serverIssueKey.hashCode() : 0;
        }
    }

    private static enum TextRangeHashKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey apply(Trackable t) {
            return new TextRangeHashKey(t);
        }
    }

    private static class TextRangeHashKey
    implements SearchKey {
        private final String ruleKey;
        private final Integer textRangeHash;

        TextRangeHashKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.textRangeHash = trackable.getTextRangeHash();
        }

        public boolean equals(Object o) {
            TextRangeHashKey that = (TextRangeHashKey)o;
            return Objects.equals(this.textRangeHash, that.textRangeHash) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + (this.textRangeHash != null ? this.textRangeHash.hashCode() : 0);
            return result;
        }
    }

    private static enum LineAndMessageKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey apply(Trackable t) {
            return new LineAndMessageKey(t);
        }
    }

    private static class LineAndMessageKey
    implements SearchKey {
        private final String ruleKey;
        private final String message;
        private final Integer line;

        LineAndMessageKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.message = trackable.getMessage();
            this.line = trackable.getLine();
        }

        public boolean equals(Object o) {
            LineAndMessageKey that = (LineAndMessageKey)o;
            return Objects.equals(this.line, that.line) && this.message.equals(that.message) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + this.message.hashCode();
            result = 31 * result + (this.line != null ? this.line.hashCode() : 0);
            return result;
        }
    }

    private static enum TextRangeHashAndMessageKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey apply(Trackable t) {
            return new TextRangeHashAndMessageKey(t);
        }
    }

    private static class TextRangeHashAndMessageKey
    implements SearchKey {
        private final String ruleKey;
        private final String message;
        private final Integer textRangeHash;

        TextRangeHashAndMessageKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.message = trackable.getMessage();
            this.textRangeHash = trackable.getTextRangeHash();
        }

        public boolean equals(Object o) {
            TextRangeHashAndMessageKey that = (TextRangeHashAndMessageKey)o;
            return Objects.equals(this.textRangeHash, that.textRangeHash) && this.message.equals(that.message) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + this.message.hashCode();
            result = 31 * result + (this.textRangeHash != null ? this.textRangeHash.hashCode() : 0);
            return result;
        }
    }

    private static enum LineHashKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey apply(Trackable t) {
            return new LineHashKey(t);
        }
    }

    private static class LineHashKey
    implements SearchKey {
        private final String ruleKey;
        private final Integer lineHash;

        LineHashKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.lineHash = trackable.getLineHash();
        }

        public boolean equals(Object o) {
            LineHashKey that = (LineHashKey)o;
            return Objects.equals(this.lineHash, that.lineHash) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + (this.lineHash != null ? this.lineHash.hashCode() : 0);
            return result;
        }
    }

    private static enum LineAndLineHashKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey apply(Trackable t) {
            return new LineAndLineHashKey(t);
        }
    }

    private static class LineAndLineHashKey
    implements SearchKey {
        private final String ruleKey;
        private final Integer line;
        private final Integer lineHash;

        LineAndLineHashKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.line = trackable.getLine();
            this.lineHash = trackable.getLineHash();
        }

        public boolean equals(Object o) {
            LineAndLineHashKey that = (LineAndLineHashKey)o;
            return Objects.equals(this.line, that.line) && Objects.equals(this.lineHash, that.lineHash) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + (this.lineHash != null ? this.lineHash.hashCode() : 0);
            result = 31 * result + (this.line != null ? this.line.hashCode() : 0);
            return result;
        }
    }

    private static enum LineAndTextRangeHashKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey apply(Trackable t) {
            return new LineAndTextRangeHashKey(t);
        }
    }

    private static class LineAndTextRangeHashKey
    implements SearchKey {
        private final String ruleKey;
        private final Integer textRangeHash;
        private final Integer line;

        LineAndTextRangeHashKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.line = trackable.getLine();
            this.textRangeHash = trackable.getTextRangeHash();
        }

        public boolean equals(Object o) {
            LineAndTextRangeHashKey that = (LineAndTextRangeHashKey)o;
            return Objects.equals(this.line, that.line) && Objects.equals(this.textRangeHash, that.textRangeHash) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + (this.textRangeHash != null ? this.textRangeHash.hashCode() : 0);
            result = 31 * result + (this.line != null ? this.line.hashCode() : 0);
            return result;
        }
    }

    @FunctionalInterface
    private static interface SearchKeyFactory
    extends Function<Trackable, SearchKey> {
        @Override
        public SearchKey apply(Trackable var1);
    }

    private static interface SearchKey {
    }
}

