/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.tracking;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedSonarLintEngine;
import org.sonarsource.sonarlint.core.client.api.connected.ServerConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ServerIssue;
import org.sonarsource.sonarlint.core.client.api.exceptions.DownloadException;
import org.sonarsource.sonarlint.core.tracking.CachingIssueTracker;
import org.sonarsource.sonarlint.core.tracking.Console;
import org.sonarsource.sonarlint.core.tracking.Logger;
import org.sonarsource.sonarlint.core.tracking.ServerIssueTrackable;

public class ServerIssueTracker {
    private final Logger logger;
    private final Console console;
    private final CachingIssueTracker issueTracker;

    public ServerIssueTracker(Logger logger, Console console, CachingIssueTracker issueTracker) {
        this.logger = logger;
        this.console = console;
        this.issueTracker = issueTracker;
    }

    public void update(ServerConfiguration serverConfiguration, ConnectedSonarLintEngine engine, String moduleKey, Collection<String> fileKeys) {
        this.update(fileKeys, fileKey -> this.fetchServerIssues(serverConfiguration, engine, moduleKey, (String)fileKey));
    }

    public void update(ConnectedSonarLintEngine engine, String moduleKey, Collection<String> fileKeys) {
        this.update(fileKeys, fileKey -> engine.getServerIssues(moduleKey, fileKey));
    }

    private void update(Collection<String> fileKeys, Function<String, List<ServerIssue>> issueGetter) {
        try {
            for (String fileKey : fileKeys) {
                List<ServerIssue> serverIssues = issueGetter.apply(fileKey);
                Collection serverIssuesTrackable = serverIssues.stream().map(ServerIssueTrackable::new).collect(Collectors.toList());
                this.issueTracker.matchAndTrackAsBase(fileKey, serverIssuesTrackable);
            }
        }
        catch (Exception e) {
            String message = "error while fetching and matching server issues";
            this.console.error(message, e);
            this.logger.error(message, e);
        }
    }

    private List<ServerIssue> fetchServerIssues(ServerConfiguration serverConfiguration, ConnectedSonarLintEngine engine, String moduleKey, String fileKey) {
        try {
            this.logger.debug("fetchServerIssues moduleKey=" + moduleKey + ", fileKey=" + fileKey);
            return engine.downloadServerIssues(serverConfiguration, moduleKey, fileKey);
        }
        catch (DownloadException e) {
            this.logger.debug("failed to download server issues", (Exception)((Object)e));
            this.console.info(e.getMessage());
            return engine.getServerIssues(moduleKey, fileKey);
        }
    }
}

