/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.tracking;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.sonarsource.sonarlint.core.tracking.IssueStore;
import org.sonarsource.sonarlint.core.tracking.IssueTrackerCache;
import org.sonarsource.sonarlint.core.tracking.Logger;
import org.sonarsource.sonarlint.core.tracking.Trackable;

public class PersistentIssueTrackerCache
implements IssueTrackerCache {
    private final Logger logger;
    static final int MAX_ENTRIES = 100;
    private final IssueStore store;
    private final Map<String, Collection<Trackable>> cache;

    public PersistentIssueTrackerCache(IssueStore store, Logger logger) {
        this.store = store;
        this.cache = new LimitedSizeLinkedHashMap();
        this.logger = logger;
    }

    @Override
    public boolean isFirstAnalysis(String file) {
        return !this.cache.containsKey(file) && !this.store.contains(file);
    }

    @Override
    public synchronized Collection<Trackable> getLiveOrFail(String file) {
        Collection<Trackable> liveTrackables = this.cache.get(file);
        if (liveTrackables != null) {
            return liveTrackables;
        }
        throw new IllegalStateException("No issues in cache for file: " + file);
    }

    @Override
    public synchronized Collection<Trackable> getCurrentTrackables(String file) {
        Collection<Trackable> liveTrackables = this.cache.get(file);
        if (liveTrackables != null) {
            return liveTrackables;
        }
        try {
            Collection<Trackable> storedTrackables = this.store.read(file);
            if (storedTrackables != null) {
                return Collections.unmodifiableCollection(storedTrackables);
            }
        }
        catch (IOException e) {
            this.logger.error(String.format("Failed to read issues from store for file %s", file), e);
        }
        return Collections.emptyList();
    }

    @Override
    public synchronized void put(String file, Collection<Trackable> trackables) {
        this.cache.put(file, trackables);
    }

    @Override
    public synchronized void clear() {
        this.store.clear();
        this.cache.clear();
    }

    public synchronized void flushAll() {
        this.logger.debug("Persisting all issues");
        this.cache.forEach((path, trackables) -> {
            try {
                this.store.save((String)path, (Collection<Trackable>)trackables);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to flush cache", e);
            }
        });
    }

    @Override
    public synchronized void shutdown() {
        this.flushAll();
    }

    private class LimitedSizeLinkedHashMap
    extends LinkedHashMap<String, Collection<Trackable>> {
        LimitedSizeLinkedHashMap() {
            super(100, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Collection<Trackable>> eldest) {
            if (this.size() <= 100) {
                return false;
            }
            String key = eldest.getKey();
            try {
                PersistentIssueTrackerCache.this.logger.debug("Persisting issues for " + key);
                PersistentIssueTrackerCache.this.store.save(key, eldest.getValue());
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Error persisting issues for %s", key), e);
            }
            return true;
        }
    }
}

