/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.tracking;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Optional;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.ObjectStore;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.PathMapper;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.Reader;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.Writer;
import org.sonarsource.sonarlint.core.tracking.Logger;
import org.sonarsource.sonarlint.core.tracking.StoreIndex;
import org.sonarsource.sonarlint.core.tracking.StoreKeyValidator;

class IndexedObjectStore<K, V>
implements ObjectStore<K, V> {
    private final Logger logger;
    private final StoreIndex<K> index;
    private final PathMapper<K> pathMapper;
    private final Reader<V> reader;
    private final Writer<V> writer;
    private final StoreKeyValidator<K> validator;

    IndexedObjectStore(StoreIndex<K> index, PathMapper<K> pathMapper, Reader<V> reader, Writer<V> writer, StoreKeyValidator<K> validator, Logger logger) {
        this.index = index;
        this.pathMapper = pathMapper;
        this.reader = reader;
        this.writer = writer;
        this.validator = validator;
        this.logger = logger;
    }

    public Optional<V> read(K key) throws IOException {
        Path path = (Path)this.pathMapper.apply(key);
        if (!path.toFile().exists()) {
            return Optional.empty();
        }
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            Optional<Object> optional = Optional.of(this.reader.apply((Object)inputStream));
            return optional;
        }
    }

    public boolean contains(K key) {
        Path path = (Path)this.pathMapper.apply(key);
        return path.toFile().exists();
    }

    public void deleteInvalid() {
        int counter = 0;
        Collection<K> keys = this.index.keys();
        for (K k : keys) {
            if (((Boolean)this.validator.apply(k)).booleanValue()) continue;
            try {
                ++counter;
                this.delete(k);
            }
            catch (IOException e) {
                Path path = (Path)this.pathMapper.apply(k);
                this.logger.error(String.format("failed to delete file '%s' for invalidated key '%s'", path, k), e);
            }
        }
        this.logger.debug(String.format("%d entries removed from the store", counter));
    }

    public void delete(K key) throws IOException {
        Path path = (Path)this.pathMapper.apply(key);
        Files.deleteIfExists(path);
        this.index.delete(key);
    }

    public void write(K key, V value) throws IOException {
        Path path = (Path)this.pathMapper.apply(key);
        this.index.save(key, path);
        Path parent = path.getParent();
        if (!parent.toFile().exists()) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            this.writer.accept((Object)out, value);
        }
    }
}

