/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.telemetry;

import com.google.common.annotations.VisibleForTesting;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.sonarlint.core.client.api.common.TelemetryClientConfig;
import org.sonarsource.sonarlint.core.client.api.util.SonarLintUtils;
import org.sonarsource.sonarlint.core.telemetry.TelemetryData;
import org.sonarsource.sonarlint.core.telemetry.TelemetryHttpFactory;
import org.sonarsource.sonarlint.core.telemetry.TelemetryPayload;
import org.sonarsource.sonarlint.core.util.ws.DeleteRequest;
import org.sonarsource.sonarlint.core.util.ws.HttpConnector;
import org.sonarsource.sonarlint.core.util.ws.PostRequest;

public class TelemetryClient {
    private static final Logger LOG = Loggers.get(TelemetryClient.class);
    private static final String TELEMETRY_PATH = "telemetry";
    private final TelemetryHttpFactory httpFactory;
    private final TelemetryClientConfig clientConfig;
    private final String product;
    private final String version;

    public TelemetryClient(TelemetryClientConfig clientConfig, String product, String version) {
        this(clientConfig, product, version, new TelemetryHttpFactory());
    }

    @VisibleForTesting
    TelemetryClient(TelemetryClientConfig clientConfig, String product, String version, TelemetryHttpFactory httpFactory) {
        this.clientConfig = clientConfig;
        this.product = product;
        this.version = version;
        this.httpFactory = httpFactory;
    }

    void upload(TelemetryData data) {
        block2: {
            try {
                TelemetryClient.sendPost(this.httpFactory.buildClient(this.clientConfig), this.createPayload(data));
            }
            catch (Exception e) {
                if (!SonarLintUtils.isInternalDebugEnabled()) break block2;
                LOG.error("Failed to upload telemetry data", e);
            }
        }
    }

    void optOut(TelemetryData data) {
        block2: {
            try {
                TelemetryClient.sendDelete(this.httpFactory.buildClient(this.clientConfig), this.createPayload(data));
            }
            catch (Exception e) {
                if (!SonarLintUtils.isInternalDebugEnabled()) break block2;
                LOG.error("Failed to upload telemetry opt-out", e);
            }
        }
    }

    private TelemetryPayload createPayload(TelemetryData data) {
        long daysSinceInstallation = data.installDate().until(LocalDate.now(), ChronoUnit.DAYS);
        return new TelemetryPayload(daysSinceInstallation, data.numUseDays(), this.product, this.version, data.usedConnectedMode());
    }

    private static void sendDelete(HttpConnector httpConnector, TelemetryPayload payload) {
        String json = payload.toJson();
        DeleteRequest post = new DeleteRequest(TELEMETRY_PATH);
        post.setMediaType("application/json");
        httpConnector.delete(post, json).failIfNotSuccessful().close();
    }

    private static void sendPost(HttpConnector httpConnector, TelemetryPayload payload) {
        String json = payload.toJson();
        PostRequest post = new PostRequest(TELEMETRY_PATH);
        post.setMediaType("application/json");
        httpConnector.post(post, json).failIfNotSuccessful().close();
    }
}

